# Metrics and checks[¶](https://developer.dataiku.com/latest/concepts-and-examples/metrics.html#metrics-and-checks "Permalink to this heading")

Note

There are two main parts related to handling of metrics and checks in Dataiku’s Python APIs:

* `dataiku.core.metrics.ComputedMetrics` in the `dataiku` package. It was initially designed for usage within DSS

* `dataikuapi.dss.metrics.ComputedMetrics` in the `dataikuapi` package. It was initially designed for usage outside of DSS.

Both classes have fairly similar capabilities

For more details on the two packages, please see Concepts and examples

## Add metric on a column[¶](https://developer.dataiku.com/latest/concepts-and-examples/metrics.html#add-metric-on-a-column "Permalink to this heading")

§ def add\_metrics\_probes\_col\_stats(probes, aggregation, column):

§ """

§ Add a metrics of column statistics to probes

§ :param probes: the list of existing probes

§ :param aggregation: which aggregation is used

§ :param column: the column dataset to use

§ Usage example:

§ .. code-block:: python

§ settings: DSSDatasetSettings = dataset.get\_settings()

§ metrics: ComputedMetrics = settings.get\_raw()['metrics']

§ add\_metrics\_probes\_col\_stats(metrics['probes'], 'MIN', 'purchase\_amount')

§ """

§ types\_index = next((index for (index, d) in enumerate(probes) if d["type"] == 'col\_stats'), None)

§ if types\_index:

§ types\_value = probes[types\_index]

§ existing\_aggregation = types\_value['configuration']['aggregates']

§ to\_append = {'aggregated': aggregation, 'column': column}

§ if to\_append not in existing\_aggregation:

§ existing\_aggregation.append(to\_append)

§ else:

§ probes.append({'computeOnBuildMode': 'NO',

§ 'configuration': {'aggregates': [{'aggregated': aggregation,

§ 'column': column}

§ ]},

§ 'enabled': True,

§ 'meta': {'level': 2, 'name': 'Columns statistics'},

§ 'type': 'col\_stats'})

## Make a defined metric visible[¶](https://developer.dataiku.com/latest/concepts-and-examples/metrics.html#make-a-defined-metric-visible "Permalink to this heading")

§ def add\_displayed\_state\_to\_metrics(displayed\_state, type\_to\_add, function\_to\_add, column=""):

§ """

§ Add to the metrics used a new one

§ :param displayed\_state: the previous state

§ :param type\_to\_add: which kind of metrics

§ :param function\_to\_add: function that been used

§ :param column: column if any

§ Usage example:

§ .. code-block:: python

§ settings: DSSDatasetSettings = dataset.get\_settings()

§ metrics: ComputedMetrics = settings.get\_raw()['metrics']

§ add\_displayed\_state\_to\_metrics(metrics['displayedState'], 'col\_stats', 'MIN', 'purchase\_amount')

§ """

§ line\_to\_add = type\_to\_add + ':' + function\_to\_add

§ if column:

§ line\_to\_add += ':' + column

§ if line\_to\_add not in displayed\_state['metrics']:

§ displayed\_state['metrics'].append(line\_to\_add)

## Define a new numerical check[¶](https://developer.dataiku.com/latest/concepts-and-examples/metrics.html#define-a-new-numerical-check "Permalink to this heading")

§ def add\_metrics\_checks\_numeric\_range(checks, label, which, parameters):

§ """

§ Add a metric if only it doesn't exist

§ :param checks: Existing checks

§ :param label: Label for the check

§ :param which: Probe for the check

§ :param parameters: Operation to check

§ Usage example:

§ .. code-block:: python

§ settings: DSSDatasetSettings = dataset.get\_settings()

§ checks = settings.get\_raw()['metricsChecks']

§ CHECK\_RECORDS\_NAME = 'Number of records should be greater than 100'

§ add\_metrics\_checks\_numeric\_range(checks, CHECK\_RECORDS\_NAME, 'records:COUNT\_RECORDS',

§ [('minimum', 100)])

§ """

§ is\_already\_present = next((check for check in checks['checks'] if check['type'] == 'numericRange' and

§ check['metricId'] == which), None)

§ if not is\_already\_present:

§ new\_metric = {

§ 'computeOnBuildMode': 'PARTITION',

§ 'meta': {

§ 'label': label,

§ 'name': 'Value in range'

§ },

§ 'metricId': which,

§ 'maximum': 0.0,

§ 'maximumEnabled': False,

§ 'minimum': 0.0,

§ 'minimumEnabled': False,

§ 'softMaximum': 0.0,

§ 'softMaximumEnabled': False,

§ 'softMinimum': 0.0,

§ 'softMinimumEnabled': False,

§ 'type': 'numericRange'

§ }

§ for parameter in parameters:

§ new\_metric[parameter[0]] = parameter[1]

§ new\_metric[parameter[0] + 'Enabled'] = True

§ checks['checks'].append(new\_metric)

## Make a defined check visible[¶](https://developer.dataiku.com/latest/concepts-and-examples/metrics.html#make-a-defined-check-visible "Permalink to this heading")

§ def set\_check\_visible(checks, label):

§ """

§ Add a defined checks to the displayed state (so the user can see it in the GUI)

§ :param checks: the metricsChecks part of the dataset settings

§ :param label: label to use

§ :return:

§ Usage example:

§ .. code-block:: python

§ settings: DSSDatasetSettings = dataset.get\_settings()

§ CHECK\_RECORDS\_NAME = 'Number of records should be greater than 100'

§ checks = settings.get\_raw()['metricsChecks']

§ set\_check\_visible(checks, CHECK\_RECORDS\_NAME)

§ """

§ displayed\_state = checks['displayedState']

§ displayed = displayed\_state['checks']

§ if label not in displayed:

§ displayed.append(label)

## Retrieve metric results[¶](https://developer.dataiku.com/latest/concepts-and-examples/metrics.html#retrieve-metric-results "Permalink to this heading")

§ def get\_metrics(dataset):

§ """

§ Compute and return all used metrics (only id) for a particular dataset

§ :param dataset: the dataset

§ Usage example:

§ .. code-block:: python

§ last\_metrics = dataset.get\_last\_metric\_values()

§ metrics = get\_metrics(dataset)

§ for metric in metrics:

§ metric\_value = last\_metrics.get\_metric\_by\_id(metric)

§ if metric\_value and metric\_value['lastValues']:

§ result[metric] = {

§ 'initialValue': metric\_value['lastValues'][0]['value']

§ }

§ """

§ dataset.compute\_metrics()

§ last\_metrics = dataset.get\_last\_metric\_values().get\_raw()

§ return\_list = list()

§ id\_metrics = list(map((lambda metric: metric['metric']['id']),

§ filter(lambda metric: metric['displayedAsMetric'], last\_metrics['metrics'])))

§ return\_list.extend(id\_metrics)

§ return return\_list

## Retrieve check results[¶](https://developer.dataiku.com/latest/concepts-and-examples/metrics.html#retrieve-check-results "Permalink to this heading")

§ def get\_checks\_used(settings):

§ """

§ Get the list of all used checks for a dataset

§ :param settings: the settings of the dataset

§ :return: the list of all checks used for this dataset

§ """

§ return list(map((lambda check: 'check:CHECK:'+check), settings['metricsChecks']['displayedState']['checks']))

§ def get\_checks(dataset):

§ """

§ Compute and return all used checks (only id) for a particular dataset

§ :param dataset: the dataset

§ Usage example:

§ .. code-block:: python

§ last\_metrics = dataset.get\_last\_metric\_values()

§ checks = get\_checks(dataset)

§ for check in checks:

§ check\_value = last\_metrics.get\_metric\_by\_id(metric)

§ if check\_value and check\_value['lastValues']:

§ result[metric] = {

§ 'initialValue': metric\_value['lastValues'][0]['value']

§ }

§ """

§ dataset.compute\_metrics()

§ dataset.run\_checks()

§ return\_list = list()

§ return\_list.extend(get\_checks\_used(dataset.get\_settings().get\_raw()))

§ return return\_list

## Reference documentation[¶](https://developer.dataiku.com/latest/concepts-and-examples/metrics.html#reference-documentation "Permalink to this heading")

### dataiku package API[¶](https://developer.dataiku.com/latest/concepts-and-examples/metrics.html#dataiku-package-api "Permalink to this heading")

|  |  |

| --- | --- |

| `dataiku.core.metrics` |  |

### dataikuapi package API[¶](https://developer.dataiku.com/latest/concepts-and-examples/metrics.html#dataikuapi-package-api "Permalink to this heading")

|  |  |

| --- | --- |

| `dataikuapi.dss.metrics` |  |
