# Plugins[¶](https://developer.dataiku.com/latest/concepts-and-examples/plugins.html#plugins "Permalink to this heading")

The API offers methods to:

* Install plugins

* Uninstall plugins and list their usages

* Update plugins

* Read and write plugin settings

* Create and update plugin code envs

* List macros that can be run

* Run macros

## Installing plugins[¶](https://developer.dataiku.com/latest/concepts-and-examples/plugins.html#installing-plugins "Permalink to this heading")

### From a Zip file[¶](https://developer.dataiku.com/latest/concepts-and-examples/plugins.html#from-a-zip-file "Permalink to this heading")

§ with open("myplugin.zip", "r") as f:

§ client.install\_plugin\_from\_archive(f)

See `install\_plugin\_from\_archive()` for more details.

### From the Dataiku plugin store[¶](https://developer.dataiku.com/latest/concepts-and-examples/plugins.html#from-the-dataiku-plugin-store "Permalink to this heading")

§ future = client.install\_plugin\_from\_store("googlesheets")

§ future.wait\_for\_result()

See `install\_plugin\_from\_store()` for more details.

### From a Git repository[¶](https://developer.dataiku.com/latest/concepts-and-examples/plugins.html#from-a-git-repository "Permalink to this heading")

§ future = client.install\_plugin\_from\_git("git@github.com:myorg/myrepo")

§ future.wait\_for\_result()

See `install\_plugin\_from\_git()` for more details.

## Uninstalling plugins[¶](https://developer.dataiku.com/latest/concepts-and-examples/plugins.html#uninstalling-plugins "Permalink to this heading")

### Listing usages of a plugin[¶](https://developer.dataiku.com/latest/concepts-and-examples/plugins.html#listing-usages-of-a-plugin "Permalink to this heading")

§ plugin = client.get\_plugin('my-plugin-id')

§ usages = plugin.list\_usages()

See `list\_usages()` for more details.

### Uninstalling a plugin[¶](https://developer.dataiku.com/latest/concepts-and-examples/plugins.html#uninstalling-a-plugin "Permalink to this heading")

§ plugin = client.get\_plugin('my-plugin-id')

§ future = plugin.delete()

Plugin deletion fails if a usage is detected. It can be forced with `force=True`:

§ plugin = client.get\_plugin('my-plugin-id')

§ future = plugin.delete(force=True)

See `delete()` for more details.

## Managing code envs[¶](https://developer.dataiku.com/latest/concepts-and-examples/plugins.html#managing-code-envs "Permalink to this heading")

§ plugin = client.get\_plugin("myplugin")

§ # Start creating the code env, and wait for it to be done

§ future = plugin.create\_code\_env()

§ result = future.wait\_for\_result()

§ # NB: If the plugin requires Python 3.6 for example, you will use something like:

§ # plugin.create\_code\_env(python\_interpreter="PYTHON36")

§ # Now the code env is created, but we still need to configure the plugin to use it

§ settings = plugin.get\_settings()

§ settings.set\_code\_env(result["envName"])

§ settings.save()

## Handling settings[¶](https://developer.dataiku.com/latest/concepts-and-examples/plugins.html#handling-settings "Permalink to this heading")

§ plugin = client.get\_plugin("myplugin")

§ # Obtain the current settings

§ settings = plugin.get\_settings()

§ raw\_settings = settings.get\_raw()

§ # Modify the settings

§ # ...

§ # And save them back

§ settings.save()

## Reference documentation[¶](https://developer.dataiku.com/latest/concepts-and-examples/plugins.html#reference-documentation "Permalink to this heading")

|  |  |

| --- | --- |

| `dataikuapi.dss.plugin.DSSPlugin`(client, ...) | A plugin on the DSS instance |

| `dataikuapi.dss.plugin.DSSPluginSettings`(...) | The settings of a plugin. |

| `dataikuapi.dss.plugin.DSSPluginUsage`(data) | Information on a usage of an element of a plugin. |

| `dataikuapi.dss.plugin.DSSMissingType`(data) | Information on a type not found while analyzing usages of a plugin. |

| `dataikuapi.dss.plugin.DSSPluginUsages`(data) | Information on the usages of a plugin. |

| `dataikuapi.dss.macro.DSSMacro`(client, ...[, ...]) | A macro on the DSS instance |
