# Project folders[¶](https://developer.dataiku.com/latest/concepts-and-examples/project-folders.html#project-folders "Permalink to this heading")

You can interact with project folders through the API.

## Basic operations[¶](https://developer.dataiku.com/latest/concepts-and-examples/project-folders.html#basic-operations "Permalink to this heading")

The ROOT project folder can be retrieved with the `get\_root\_project\_folder()` method.

§ root\_folder = client.get\_root\_project\_folder()

Alternatively any project folder can be retrieved with its ID with the `get\_project\_folder()` method.

§ prj\_folder = client.get\_project\_folder(prj\_folder\_id)

Getting basic attributes:

§ # Getting the id of a project folder (for "get\_project\_folder")

§ id = prj\_folder.id

§ # Getting the name of a project folder:

§ name = prj\_folder.name

§ # Getting the "virtual path" of a project folder (NB: for information purpose only, does not hold special significance)

§ path = prj\_folder.get\_path()

## Navigating within project folders[¶](https://developer.dataiku.com/latest/concepts-and-examples/project-folders.html#navigating-within-project-folders "Permalink to this heading")

In order to navigate from a project folder, its parent and children can be retrieved.

§ parent = prj\_folder.get\_parent()

§ children = prj\_folder.list\_child\_folders()

This will list all its projects.

§ project\_key\_list = prj\_folder.list\_project\_keys()

§ project\_list = prj\_folder.list\_projects()

## Finding the folder of a project[¶](https://developer.dataiku.com/latest/concepts-and-examples/project-folders.html#finding-the-folder-of-a-project "Permalink to this heading")

From a project, you can find its project folder

§ project = client.get\_project("MYPROJECT")

§ folder = project.get\_project\_folder()

§ print("Project is in folder %s (path %s)" % (folder.name, folder.get\_path()))

## Creating entities[¶](https://developer.dataiku.com/latest/concepts-and-examples/project-folders.html#creating-entities "Permalink to this heading")

To create a child project folder, use the `create\_sub\_folder()` method.

§ # Creating a new project folder

§ newborn\_child = prj\_folder.create\_sub\_folder(project\_folder\_name)

§ # Creating a project directly into a project folder

§ new\_project = prj\_folder.create\_project(project\_key, project\_name, owner)

## Moving entities[¶](https://developer.dataiku.com/latest/concepts-and-examples/project-folders.html#moving-entities "Permalink to this heading")

To move a project folder to another location (into another project folder), use the `move\_to()` method.

§ prj\_folder.move\_to(new\_parent)

§ prj\_folder.move\_project\_to(project\_key, new\_parent)

You can also move a project directly

§ project.move\_to\_folder(target\_folder)

## Managing project folders[¶](https://developer.dataiku.com/latest/concepts-and-examples/project-folders.html#managing-project-folders "Permalink to this heading")

### Deleting a project folder[¶](https://developer.dataiku.com/latest/concepts-and-examples/project-folders.html#deleting-a-project-folder "Permalink to this heading")

§ prj\_folder.delete()

### Modifying settings[¶](https://developer.dataiku.com/latest/concepts-and-examples/project-folders.html#modifying-settings "Permalink to this heading")

§ pf\_settings = prj\_folder.get\_settings()

§ pf\_settings.set\_name(new\_name)

§ pf\_settings.set\_owner(new\_owner)

§ pf\_permissions = pf\_settings.get\_permissions()

§ pf\_permissions.append(new\_permission\_item)

§ pf\_settings.save()

## Reference documentation[¶](https://developer.dataiku.com/latest/concepts-and-examples/project-folders.html#reference-documentation "Permalink to this heading")

|  |  |

| --- | --- |

| `dataikuapi.dss.projectfolder.DSSProjectFolder`(...) | A handle to interact with a project folder on the DSS instance. |

| `dataikuapi.dss.projectfolder.DSSProjectFolderSettings`(...) | A handle to interact with project folder settings |
