# Project libraries[¶](https://developer.dataiku.com/latest/concepts-and-examples/project-libraries.html#project-libraries "Permalink to this heading")

You can interact with the Library of each project through the API.

## Getting the DSSLibrary object[¶](https://developer.dataiku.com/latest/concepts-and-examples/project-libraries.html#getting-the-dsslibrary-object "Permalink to this heading")

You must first retrieve the `DSSLibrary` through the `get\_library()` method

§ project = client.get\_project("MYPROJECT")

§ library = project.get\_library()

## Retrieving the content of a file[¶](https://developer.dataiku.com/latest/concepts-and-examples/project-libraries.html#retrieving-the-content-of-a-file "Permalink to this heading")

§ library\_file = library.get\_file("/file.txt")

§ print("Content: %s" % library\_file.read()))

§ # Alternate ways to retrieve a file handle

§ library\_file = library.get\_file("/python/some\_code.py")

§ library\_file = library.get\_folder("/python").get\_file("/some\_code.py")

## Getting the list of all the library items[¶](https://developer.dataiku.com/latest/concepts-and-examples/project-libraries.html#getting-the-list-of-all-the-library-items "Permalink to this heading")

§ def print\_library\_items(item):

§ print(item.path)

§ if "list" in dir(item):

§ for child in item.list():

§ print\_library\_items(child)

§ for item in lib.list():

§ print\_library\_items(item)

## Add a new folder in the library[¶](https://developer.dataiku.com/latest/concepts-and-examples/project-libraries.html#add-a-new-folder-in-the-library "Permalink to this heading")

§ library.add\_folder("/new\_folder")

§ library.add\_folder("/python/new\_sub\_folder")

§ library.get\_folder("/python").add\_folder("another\_sub\_folder")

## Add a new file in the library[¶](https://developer.dataiku.com/latest/concepts-and-examples/project-libraries.html#add-a-new-file-in-the-library "Permalink to this heading")

§ # create a new file in a folder

§ file = open("/path/to/local/file")

§ library.put\_file("/new\_folder/file.txt", file)

## Rename a file or a folder in the library[¶](https://developer.dataiku.com/latest/concepts-and-examples/project-libraries.html#rename-a-file-or-a-folder-in-the-library "Permalink to this heading")

§ # rename a file in the library

§ library.get\_file("/folder/file.txt").rename("renamed\_file.txt")

§ # rename a folder in the library

§ library.get\_folder("/folder").rename("renamed\_folder")

## Move a file or a folder in the library[¶](https://developer.dataiku.com/latest/concepts-and-examples/project-libraries.html#move-a-file-or-a-folder-in-the-library "Permalink to this heading")

§ # move a file in the library

§ library.get\_file("/folder/file.txt").move\_to(library.get\_folder("/folder2"))

§ # move a folder in the library

§ library.get\_folder("/folder").move\_to(library.get\_folder("/folder2"))

## Delete a file or a folder from the library[¶](https://developer.dataiku.com/latest/concepts-and-examples/project-libraries.html#delete-a-file-or-a-folder-from-the-library "Permalink to this heading")

§ library.get\_file("/path/to/item").delete()

§ library.get\_folder("/path/to").get\_file("/item").delete()

## Reference documentation[¶](https://developer.dataiku.com/latest/concepts-and-examples/project-libraries.html#reference-documentation "Permalink to this heading")

|  |  |

| --- | --- |

| `dataikuapi.dss.projectlibrary.DSSLibrary`(...) | A handle to manage the library of a project It saves locally a copy of taxonomy to help navigate in the library All modifications done through this object and related library items are done locally and on remote. Note: Taxonomy modifications done outside this library are not reflected locally. You should reload the library in this case. |
