# Using the APIs outside of DSS[¶](https://developer.dataiku.com/latest/getting-started/outside-usage.html#using-the-apis-outside-of-dss "Permalink to this heading")

Most of the Python APIs offered by DSS can be used outside of DSS. This allows you:

* To automate various kinds of tasks related to DSS

* To develop recipes, webapps, … or any kind of DSS code in your

favorite IDE, outside of DSS.

## Using the `dataikuapi` REST client package[¶](https://developer.dataiku.com/latest/getting-started/outside-usage.html#using-the-dataikuapi-rest-client-package "Permalink to this heading")

Please see `The main DSS Client <../concepts-and-examples/client>`{.interpreted-text role=“doc”}

Important note: if you follow the following instructions for using the `dataiku` package, you can then also use `dataiku.api\_client()` idiom in order to get a handle to a REST client. You’ll still need to install the package, however

## Using the `dataiku` package[¶](https://developer.dataiku.com/latest/getting-started/outside-usage.html#using-the-dataiku-package "Permalink to this heading")

The `dataiku` package is not available through pip. Instead, it can be obtained directly from your DSS instance itself.

### Installing the package[¶](https://developer.dataiku.com/latest/getting-started/outside-usage.html#installing-the-package "Permalink to this heading")

#### Directly through pip[¶](https://developer.dataiku.com/latest/getting-started/outside-usage.html#directly-through-pip "Permalink to this heading")

Run:

§ pip install http(s)://DSS_HOST:DSS_PORT/public/packages/dataiku-internal-client.tar.gz

If you use HTTPS without a proper certificate, you may need to add `--trusted-host=DSS\_HOST:DSS\_PORT` to your pip command line.

#### In a requirements.txt file[¶](https://developer.dataiku.com/latest/getting-started/outside-usage.html#in-a-requirements-txt-file "Permalink to this heading")

In your requirements.txt file, add a line:

§ http(s)://DSS_HOST:DSS_PORT/public/packages/dataiku-internal-client.tar.gz

Then update your requirements with `pip install -r requirements.txt`

If you use HTTPS without a proper certificate, you may need to add `--trusted-host=DSS\_HOST:DSS\_PORT` to your pip command line.

#### Manually with download[¶](https://developer.dataiku.com/latest/getting-started/outside-usage.html#manually-with-download "Permalink to this heading")

* Download the package’s tar.gz file from your DSS instance:

`http(s)://DSS\_HOST:DSS\_PORT/public/packages/dataiku-internal-client.tar.gz`

* Install it with `pip install dataiku-internal-client.tar.gz`

### Setting up the connection with DSS[¶](https://developer.dataiku.com/latest/getting-started/outside-usage.html#setting-up-the-connection-with-dss "Permalink to this heading")

In order to connect to DSS, you’ll need to supply:

* The URL of DSS

* A REST API key in order to perform actions

We strongly recommend that you use a personal API key. Please see Public API Keys for more information

There are three ways to supply this information:

#### Through code[¶](https://developer.dataiku.com/latest/getting-started/outside-usage.html#through-code "Permalink to this heading")

§ import dataiku

§ dataiku.set\_remote\_dss("http(s)://DSS\_HOST:DSS\_PORT/", "Your API Key secret")

#### Through environment variables[¶](https://developer.dataiku.com/latest/getting-started/outside-usage.html#through-environment-variables "Permalink to this heading")

Before starting your Python, export the following environment variables:

§ export DKU\_DSS\_URL=http(s)://DSS_HOST:DSS_PORT/

§ export DKU\_API\_KEY="Your API key secret"

#### Through configuration file[¶](https://developer.dataiku.com/latest/getting-started/outside-usage.html#through-configuration-file "Permalink to this heading")

Create or edit the file `~/.dataiku/config.json` (or `%USERPROFILE%/.dataiku/config.json` on Windows), and add the following content:

§ {

§ "dss\_instances": {

§ "default": {

§ "url": "http(s)://DSS\_HOST:DSS\_PORT/",

§ "api\_key": "Your API key secret"

§ }

§ },

§ "default\_instance": "default"

§ }

You can now use most of the functions of the `dataiku` package from your own machine, independently from the DSS installation.

If at some point you need to clear the connection settings, you can do so with the following code:

§ dataiku.clear\_remote\_dss()

| The configuration will be cleared. | If you are using the client within your DSS instance, it will target the API of your instance. | Otherwise, you will need to reset your connection by following the procedure described here.

### Advanced options[¶](https://developer.dataiku.com/latest/getting-started/outside-usage.html#advanced-options "Permalink to this heading")

#### Disabling SSL certificate check[¶](https://developer.dataiku.com/latest/getting-started/outside-usage.html#disabling-ssl-certificate-check "Permalink to this heading")

If your DSS has SSL enabled, the packages will verify the certificate. In order for this to work, you may need to add the root authority that signed the DSS SSL certificate to your local trust store. Please refer to your OS or Python manual for instructions.

If this is not possible, you can also disable checking the SSL certificate:

* Through code:

§ import dataiku

§ dataiku.set\_remote\_dss("http(s)://DSS\_HOST:DSS\_PORT/", "Your API Key secret", no\_check\_certificate=True)

* Through environment variables: Not supported at the moment

* Through configuration file: Modify the configuration file as such:

§ {

§ "dss\_instances": {

§ "default": {

§ "url": "http(s)://DSS\_HOST:DSS\_PORT/",

§ "api\_key": "Your API key secret",

§ "no\_check\_certificate": true

§ }

§ },

§ "default\_instance": "default"

§ }
