# Obtaining support[¶](https://doc.dataiku.com/dss/latest/troubleshooting/obtaining-support.html#obtaining-support "Permalink to this headline")

If you encounter issues for which you can’t get an explanation by reading through the error documentation and Diagnosing and debugging issues, or have a question, you may need to obtain support.

## Academy[¶](https://doc.dataiku.com/dss/latest/troubleshooting/obtaining-support.html#academy "Permalink to this headline")

The Dataiku Academy is the place to go to first learn about DSS concepts.

## Community Answers[¶](https://doc.dataiku.com/dss/latest/troubleshooting/obtaining-support.html#community-answers "Permalink to this headline")

We maintain a public community where you can browse for existing answers, or ask your own question.

## Live chat[¶](https://doc.dataiku.com/dss/latest/troubleshooting/obtaining-support.html#live-chat "Permalink to this headline")

Depending on your DSS license, you may have access to our live chat directly in DSS. Live chat is also available on Dataiku website.

## Editor support (for Dataiku Online customers specifically)[¶](https://doc.dataiku.com/dss/latest/troubleshooting/obtaining-support.html#editor-support-for-dataiku-online-customers-specifically "Permalink to this headline")

If you are a Dataiku Online customer that is using a **hosted** instance, there is a native built-in support window that you can access from your platform directly. For more details, please refer to our How to obtain support on Dataiku Online knowledge base article.

## Editor support (for all other Dataiku customers)[¶](https://doc.dataiku.com/dss/latest/troubleshooting/obtaining-support.html#editor-support-for-all-other-dataiku-customers "Permalink to this headline")

If you are a Dataiku customer that is using your own infrastructure or currently running an evaluation, you may contact Dataiku support, either by:

* Going to the support portal

* Sending a mail to support -at- dataiku -dot- com.

### Guidelines for submitting a support ticket[¶](https://doc.dataiku.com/dss/latest/troubleshooting/obtaining-support.html#guidelines-for-submitting-a-support-ticket "Permalink to this headline")

Describe your issue. Include screenshots if it appears to be a front-end issue.

Where did the issue happen?

If something had previously been working, what did you recently change?

Try to describe the set of steps you took that resulted in the error or issue you now see. Try to be precise!

Let us know what you have already tried to do to fix the problem on your own, following the instructions on Diagnosing and debugging issues. Include any job or instance diagnosis files, as appropriate.

Specify the appropriate and correct priority (please refer to the following section).

### Defining the priority of a support ticket[¶](https://doc.dataiku.com/dss/latest/troubleshooting/obtaining-support.html#defining-the-priority-of-a-support-ticket "Permalink to this headline")

We generally aim to be responsive with all support tickets. However, when opening a support ticket, please use the following criteria to specify the appropriate priority to help ensure that it is classified correctly:

* **P1/Urgent** - Reserved for ONLY the most critical “system is down” situations where DSS is **completely inoperative** and/or your production environment is unusable. This can be a condition that is severely and significantly impacting the Design, Automation, and API nodes where no procedural workaround exists.

* **P2/High** - Reserved for serious or high-impact business conditions related to DSS that are severely affecting a substantial number of users and where no procedural workaround exists.

* **P3/Medium** - A medium to low-impact issue in DSS that can involve partial but non-critical functionality loss. Alternatively, this may also be a minor issue with limited or no loss of functionality or impact in your environment for which a workaround is available. *This should be the default priority selected for most issues and questions.*

* **P4/Low** - DSS is functional and there is no material impact on the quality, performance, or functionality of your environment. Relates only to proposed feature enhancements, proposed modifications, or other requests (such as documentation, usage help, etc.)
