# Common issues[¶](https://doc.dataiku.com/dss/latest/troubleshooting/problems/index.html#common-issues "Permalink to this headline")

This section lists some common issues encountered in DSS and associated solutions and tips.

* DSS does not start / Cannot connect

+ Check processes state

+ Verify local connectivity

+ DSS start (or stop) fails

- Server port already in use

- Server requires authentication

+ Kill all DSS processes

+ Diagnose process failures

* Cannot login to DSS

+ You are using the Dataiku Online Trial

+ You are using DSS Free Edition

+ You are using DSS Enterprise Edition

+ Your credentials don’t work

+ Resetting a forgotten DSS password

- If you still have access to DSS

- If you have lost all access to DSS

* DSS crashes / The “Disconnected” overlay appears

* Websockets problems

+ I am seeing the “Could not establish WebSocket connection” message

- Causes

- Consequences

- Remedies

* Cannot connect to a SQL database

* A job fails

+ Source dataset is not ready

+ Dataset is already being built

+ One of the recipes failed

+ Getting a job diagnosis

* A scenario fails

+ One “build” step failed

+ Getting a scenario diagnosis

* A ML model training fails

+ MemoryError (In-memory training only)

+ Process died (killed - maybe out of memory)

* “Your user profile does not allow” issues

+ If you are a DSS administrator

+ If you are not a DSS administrator

* Invalid HMAC / Decryption failed

+ Remedy

* Receiving “java.lang.NoClassDefFoundError”

+ Receiving “java.lang.NoClassDefFoundError: org/apache/hadoop/”

- Resolution

+ Receiving java.lang.NoClassDefFoundError for operations that previously did not throw an error

- Resolution

* The server selected protocol version TLS10 is not accepted by client preferences [TLS12]

+ Resolution
