# Scatter Charts[¶](https://doc.dataiku.com/dss/latest/visualization/charts-scatters.html#scatter-charts "Permalink to this headline")

The Scatter charts build visualizations that display plotted points, based on the following types of columns:

* Required X and Y axis columns, whose values determine the location of the plotted points.

* An optional Color column that colors the points based upon the column’s values. If the Color column is not specified, then the points have a uniform color.

* An optional Size column that sizes the points based upon the column’s values. If the Size column is not specified, then the points have a uniform size.

* Chart Layouts

+ Basic

+ Grouped

+ Binned

## Chart Layouts[¶](https://doc.dataiku.com/dss/latest/visualization/charts-scatters.html#chart-layouts "Permalink to this headline")

### Basic[¶](https://doc.dataiku.com/dss/latest/visualization/charts-scatters.html#basic "Permalink to this headline")

The **Scatter Plot** layout allows you to add an optional Shape column that changes the shape of the points based upon the column’s values. The Shape column should have a relatively limited number of value to avoid clutter.

The Basic Scatterplot plots a point at each individual X-Y value combination. Thus, each point has a single value from the Color, Size, and Shape columns, and these columns can be text or numeric.

### Grouped[¶](https://doc.dataiku.com/dss/latest/visualization/charts-scatters.html#grouped "Permalink to this headline")

The **Grouped Bubbles** layout adds a required Grouping column. First the Grouping column is discretized into bins. For each binned value, it plots one point in the chart. The X-Y location of each point is determined by aggregating the X and Y axis columns. Likewise, the color and size of each point is determined by aggregating those columns, if specified. The X and Y axis, Color, and Size columns must all therefore be numeric, so they can be aggregated.

### Binned[¶](https://doc.dataiku.com/dss/latest/visualization/charts-scatters.html#binned "Permalink to this headline")

Binned Scatter charts discretize the values of X and Y axis columns, and create one point for each X-Y bin. The dimensions do not need to be numerical. The color and size of each circles are represented using aggregations of measures.

* The **Bubble** layout allows the X and Y axis columns to be text or numeric. If an axis column is text, its raw values are used.

* The **Rectangle** layout is like the Bubble layout, but instead of points it plots rectangles. The resulting chart resemble a heat map.

* The **Hexagon** layout requires both the X and Y axis columns to be numeric. Hexagonal binning generally provides a better overview of the distribution of your data than the Bubble or Rectangle plots, and can better represent large amounts of data.

Warning

Hexagonal binning is incompatible with live in-database processing. If you use in-database processing and want to enable hexagonal binning, you will need to switch to DSS Charts Engine.
