# Charts[¶](https://doc.dataiku.com/dss/latest/visualization/index.html#charts "Permalink to this headline")

Charts are visual aggregations of data that provide insight into the relationships in your datasets.

DSS delivers an advanced data visualization engine through the Charts tab of a dataset or visual analysis. The chart-building interface is essentially the same in both locations, with the following important caveats.

* Charts in a visual analysis can work in real-time on the output of a data preparation Script. Instead of rebuilding a dataset, simply add a step to the script and view the result immediately.

* Charts in a dataset can be published as insights for inclusion in dashboards, while charts in a visual analysis cannot. However, when a visual analysis is deployed as a Prepare recipe, its charts can be transferred during deployment to the output dataset.

* Charts in a dataset can make use of the in-database execution engine, while charts in a visual analysis are always run in the DSS engine.

* The Charts Interface

* Sampling & Engine

+ Charts Execution Engines

- DSS

- In-database

+ Sampling

+ Limit Memory Usage

- RAM

- Number of bins

* Basic Charts

+ Chart Layouts

- Bar

- Lines & Curves

- Pie & Donuts

+ Column Processing Options

- Binning Column

- Summary Column

- Grouping Column

* Tables

* Scatter Charts

+ Chart Layouts

- Basic

- Grouped

- Binned

* Map Charts

+ Chart Layouts

- Scatter

- Geometry

* Choose the order of the geo layers

* Set the colors

* Aggregate geometries

- Density

- Binned

- Administrative

+ Geographic columns

+ Map backgrounds

* Other Charts

+ Boxplot

+ 2D Distribution

+ Lift Chart

+ Treemap

+ KPI

* Common Chart Elements

* Color palettes

+ Palette types

- Discrete palettes

- Continuous palettes

- Diverging palettes

+ Custom palettes

+ Meaning-associated palettes

+ Color assignations

* Formatting

+ Number Formatting

+ Display labels

* Filter settings

+ Include/Exclude other values

+ Only relevant values/All values in sample
