# Macros[¶](https://doc.dataiku.com/dss/latest/api/python/macros.html#macros "Permalink to this headline")

The API offers methods to:

* List macros that can be run

* Run macros

## Reference documentation[¶](https://doc.dataiku.com/dss/latest/api/python/macros.html#reference-documentation "Permalink to this headline")

*class* `dataikuapi.dss.macro.``DSSMacro`(*client*, *project\_key*, *runnable\_type*, *definition=None*)

A macro on the DSS instance

* Parameters: * **client** – an api client to connect to the DSS backend
* **project\_key** – identifier of the project to access the macro from
* **runnable\_type** – identifier of the macro
* **definition** – if available, the macro’s definition

`get_definition`()

Get the macro definition. The result contains :

* identification of the macro

* display info like label

* what kind of result the macro returns (html, file, url, …)

* the list of parameters to pass in order to start a run (adminParams is

empty unless the authentication of the api client covers admin rights)

`run`(*params=None*, *admin\_params=None*, *wait=True*)

Run the macro from the project

* Parameters: * **params** (*dict*) – parameters to the macro run (defaults to {})
* **admin\_params** (*dict*) – admin parameters to the macro run (if the authentication of
the api client does not cover admin rights, they are ignored, defaults to {})
* **wait** – if True, the call blocks until the run is finished

* Returns: a run identifier to use to abort or retrieve results

`abort`(*run\_id*)

Aborts a run of the macro

* Parameters: **run\_id** – a run identifier, as return from the run() method

`get_status`(*run\_id*)

Polls the status of a run of the macro

* Parameters: **run\_id** – a run identifier, as return from the run() method

* Returns: a dict holding information about whether the run exists, is still running,
errors that might have happened during the run, and result type if it finished.

`get_result`(*run\_id*, *as\_type=None*)

Retrieve the result of a run of the macro

* Parameters: * **run\_id** – a run identifier, as return from the run() method
* **as\_type** – if not None, one of ‘string’ or ‘json’

* Returns: the result of the macro run, as a file-like is as\_type is None; as a str if
as\_type is “string”; as an object if as\_type is “json”. If the macro is still 
running, an Exception is raised
