# Fleet Manager Instance Templates[¶](https://doc.dataiku.com/dss/latest/api/python/fleetmanager/instancetemplates.html#fleet-manager-instance-templates "Permalink to this headline")

Instance settings templates allow to set several properties used when creating a new instance.

## Create a new settings template[¶](https://doc.dataiku.com/dss/latest/api/python/fleetmanager/instancetemplates.html#create-a-new-settings-template "Permalink to this headline")

§ import dataikuapi

§ key\_id = "<my key id>"

§ key\_secret = "<my key secret>"

§ # <Cloud vendor> is either AWS, Azure or GCP

§ client = dataikuapi.FMClient<Cloud vendor>("https://localhost", key\_id, key\_secret)

§ creator = client.new\_instance\_template\_creator("MyTemplate")

§ # set the properties of your template

§ ...

§ setting\_template = creator.create()

## Reference API doc[¶](https://doc.dataiku.com/dss/latest/api/python/fleetmanager/instancetemplates.html#reference-api-doc "Permalink to this headline")

*class* `dataikuapi.fm.instancesettingstemplates.``FMInstanceSettingsTemplate`(*client*, *ist\_data*)

`save`()

Update this template

`delete`()

Delete this template

* Returns: the Future object representing the deletion process

* Return type: `dataikuapi.fm.future.FMFuture`

`add_setup_action`(*setup\_action*)

Add a setup action

* Parameters: **setup\_action** (`dataikuapi.fm.instancesettingstemplates.FMSetupAction`) – the action to add

* Return type: `dataikuapi.fm.instancesettingstemplates.FMInstanceSettingsTemplate`

*class* `dataikuapi.fm.instancesettingstemplates.``FMInstanceSettingsTemplateCreator`(*client*, *label*)

`create`()

Create a new instance settings template.

* Returns: a newly created template

* Return type: `dataikuapi.fm.instancesettingstemplates.FMInstanceSettingsTemplate`

`with_setup_actions`(*setup\_actions*)

Add setup actions

* Parameters: **setup\_actions** (list of `dataikuapi.fm.instancesettingstemplates.FMSetupActions`) – List of setup actions to be played on an instance

* Return type: `dataikuapi.fm.instancesettingstemplates.FMInstanceSettingsTemplateCreator`

`with_license`(*license\_file\_path=None*, *license\_string=None*)

Override global license

* Parameters: * **license\_file\_path** (*str*) – Optional, load the license from a json file
* **license\_string** (*str*) – Optional, load the license from a json string

* Return type: `dataikuapi.fm.instancesettingstemplates.FMInstanceSettingsTemplateCreator`

*class* `dataikuapi.fm.instancesettingstemplates.``FMAWSInstanceSettingsTemplateCreator`(*client*, *label*)

`with_aws_keypair`(*aws\_keypair\_name*)

Add an AWS Keypair to the DSS instance. Needed to get SSH access to the DSS instance, using the centos user.

* Parameters: **aws\_keypair\_name** (*str*) – Name of an AWS key pair to add to the instance.

* Return type: `dataikuapi.fm.instancesettingstemplates.FMAWSInstanceSettingsTemplateCreator`

`with_startup_instance_profile`(*startup\_instance\_profile\_arn*)

Add an Instance Profile to be assigned to the DSS instance on startup

* Parameters: **startup\_instance\_profile\_arn** (*str*) – ARN of the Instance profile assigned to the DSS instance at startup time

* Return type: `dataikuapi.fm.instancesettingstemplates.FMAWSInstanceSettingsTemplateCreator`

`with_runtime_instance_profile`(*runtime\_instance\_profile\_arn*)

Add an Instance Profile to be assigned to the DSS instance when running

* Parameters: **runtime\_instance\_profile\_arn** (*str*) – ARN of the Instance profile assigned to the DSS instance during runtime

* Return type: `dataikuapi.fm.instancesettingstemplates.FMAWSInstanceSettingsTemplateCreator`

`with_restrict_aws_metadata_server_access`(*restrict\_aws\_metadata\_server\_access=True*)

Restrict AWS metadata server access on the DSS instance.

* Parameters: **restrict\_aws\_metadata\_server\_access** (*boolean*) – Optional, If true, restrict the access to the metadata server access. Defaults to true

* Return type: `dataikuapi.fm.instancesettingstemplates.FMAWSInstanceSettingsTemplateCreator`

`with_default_aws_api_access_mode`()

The DSS Instance will use the Runtime Instance Profile to access AWS API.

* Return type: `dataikuapi.fm.instancesettingstemplates.FMAWSInstanceSettingsTemplateCreator`

`with_keypair_aws_api_access_mode`(*aws\_access\_key\_id*, *aws\_keypair\_storage\_mode='NONE'*, *aws\_secret\_access\_key=None*, *aws\_secret\_access\_key\_aws\_secret\_name=None*, *aws\_secrets\_manager\_region=None*)

DSS Instance will use an Access Key to authenticate against the AWS API.

* Parameters: * **aws\_access\_key\_id** (*str*) – AWS Access Key ID.
* **aws\_keypair\_storage\_mode** (*str*) – Optional, the storage mode of the AWS api key. Accepts “NONE”, “INLINE\_ENCRYPTED” or “AWS\_SECRETS\_MANAGER”. Defaults to “NONE”
* **aws\_secret\_access\_key** (*str*) – Optional, AWS Access Key Secret. Only needed if keypair\_storage\_mode is “INLINE\_ENCRYPTED”
* **aws\_secret\_access\_key\_aws\_secret\_name** (*str*) – Optional, ASM secret name. Only needed if aws\_keypair\_storage\_mode is “AWS\_SECRET\_MANAGER”
* **aws\_secrets\_manager\_region** (*str*) – Optional, Secret Manager region to use. Only needed if aws\_keypair\_storage\_mode is “AWS\_SECRET\_MANAGER”

* Return type: `dataikuapi.fm.instancesettingstemplates.FMAWSInstanceSettingsTemplateCreator`

*class* `dataikuapi.fm.instancesettingstemplates.``FMAzureInstanceSettingsTemplateCreator`(*client*, *label*)

`with_ssh_key`(*ssh\_public\_key*)

Add an SSH public key to the DSS Instance. Needed to access it through SSH, using the centos user.

* Parameters: **ssh\_public\_key** (*str*) – The content of the public key to add to the instance.

* Return type: `dataikuapi.fm.instancesettingstemplates.FMAzureInstanceSettingsTemplateCreator`

`with_startup_managed_identity`(*startup\_managed\_identity*)

Add a managed identity to be assign to the DSS instance on startup

* Parameters: **startup\_managed\_identity** (*str*) – Managed Identity ID

* Return type: `dataikuapi.fm.instancesettingstemplates.FMAzureInstanceSettingsTemplateCreator`

`with_runtime_managed_identity`(*runtime\_managed\_identity*)

Add a managed identity to be assign to the DSS instance when running

* Parameters: **runtime\_managed\_identity** (*str*) – Managed Identity ID

* Return type: `dataikuapi.fm.instancesettingstemplates.FMAzureInstanceSettingsTemplateCreator`

*class* `dataikuapi.fm.instancesettingstemplates.``FMGCPInstanceSettingsTemplateCreator`(*client*, *label*)

`with_ssh_key`(*ssh\_public\_key*)

Add an SSH public key to the DSS Instance. Needed to access it through SSH, using the centos user.

* Parameters: **ssh\_public\_key** (*str*) – The content of the public key to add to the instance.

* Return type: `dataikuapi.fm.instancesettingstemplates.FMGCPInstanceSettingsTemplateCreator`

`with_restrict_metadata_server_access`(*restrict\_metadata\_server\_access=True*)

Restrict GCloud metadata server access on the DSS instance.

* Parameters: **restrict\_metadata\_server\_access** (*boolean*) – Optional, If true, restrict the access to the metadata server access. Defaults to true

* Return type: `dataikuapi.fm.instancesettingstemplates.FMGCPInstanceSettingsTemplateCreator`

`with_block_project_wide_keys`(*block\_project\_wide\_keys=True*)

Restrict GCloud metadata server access on the DSS instance.

* Parameters: **block\_project\_wide\_keys** (*boolean*) – Optional, If true, block project-wide ssh keys on the instance. Defaults to true

* Return type: `dataikuapi.fm.instancesettingstemplates.FMGCPInstanceSettingsTemplateCreator`

`with_runtime_service_account`(*startup\_service\_account*)

Add a service account to be assigned to the DSS instance on startup

* Parameters: **startup\_service\_account** (*str*) – service account email

* Return type: `dataikuapi.fm.instancesettingstemplates.FMGCPInstanceSettingsTemplateCreator`

*class* `dataikuapi.fm.instancesettingstemplates.``FMSetupAction`(*setupActionType*, *params=None*)

*static* `add_authorized_key`(*ssh\_key*)

Return an ADD\_AUTHORIZED\_KEY setup action

* Return type: `dataikuapi.fm.instancesettingstemplates.FMSetupAction`

*static* `run_ansible_task`(*stage*, *yaml\_string*)

Return a RUN\_ANSIBLE\_TASK setup action

* Parameters: * **stage** (`dataikuapi.fm.instancesettingstemplates.FMSetupActionStage`) – the action stage
* **yaml\_string** (*str*) – a yaml encoded string defining the ansibles tasks to run

* Return type: `dataikuapi.fm.instancesettingstemplates.FMSetupAction`

*static* `install_system_packages`(*packages*)

Return an INSTALL\_SYSTEM\_PACKAGES setup action

* Parameters: **packages** (*list*) – List of packages to install

* Return type: `dataikuapi.fm.instancesettingstemplates.FMSetupAction`

*static* `setup_advanced_security`(*basic\_headers=True*, *hsts=False*)

Return a SETUP\_ADVANCED\_SECURITY setup action

* Parameters: * **basic\_headers** (*boolean*) – Optional, Prevent browsers to render Web content served by DSS to be embedded into a frame, iframe, embed or object tag. Defaults to True
* **hsts** (*boolean*) – Optional, Enforce HTTP Strict Transport Security. Defaults to False

* Return type: `dataikuapi.fm.instancesettingstemplates.FMSetupAction`

*static* `install_jdbc_driver`(*database\_type*, *url*, *paths\_in\_archive=None*, *http\_headers=None*, *http\_username=None*, *http\_password=None*, *datadir\_subdirectory=None*)

Return a INSTALL\_JDBC\_DRIVER setup action

* Parameters: * **database\_type** (`dataikuapi.fm.instancesettingstemplates.FMSetupActionAddJDBCDriverDatabaseType`) – the database type
* **url** (*str*) – The full address to the driver. Supports http(s)://, s3://, abs:// or file:// endpoints
* **paths\_in\_archive** (*list*) – Optional, must be used when the driver is shipped as a tarball or a ZIP file. Add here all the paths to find the JAR files in the driver archive. Paths are relative to the top of the archive. Wildcards are supported.
* **http\_headers** (*dict*) – Optional, If you download the driver from a HTTP(S) endpoint, add here the headers you want to add to the query. This setting is ignored for any other type of download.
* **http\_username** (*str*) – Optional, If the HTTP(S) endpoint expect a Basic Authentication, add here the username. To explicitely specify which Assigned Identity use if the machine have several, set the client\_id here. To authenticate with a SAS Token on Azure Blob Storage (not recommended), use “token” as the value here.
* **http\_password** (*str*) – Optional, If the HTTP(S) endpoint expect a Basic Authentication, add here the password. To authenticate with a SAS Token on Azure Blob Storage (not recommended), store the token in this field.
* **datadir\_subdirectory** (*str*) – Optional, Some drivers are shipped with a high number of JAR files along with them. In that case, you might want to install them under an additional level in the DSS data directory. Set the name of this subdirectory here. Not required for most drivers.

* Return type: `dataikuapi.fm.instancesettingstemplates.FMSetupAction`

*static* `setup_k8s_and_spark`()

Return a SETUP\_K8S\_AND\_SPARK setup action

* Return type: `dataikuapi.fm.instancesettingstemplates.FMSetupAction`

*class* `dataikuapi.fm.instancesettingstemplates.``FMSetupActionStage`(*value*)

An enumeration.

* 
`after_dss_startup` *= 'after\_dss\_startup'*:

* 
`after_install` *= 'after\_install'*:

* 
`before_install` *= 'before\_install'*:

*class* `dataikuapi.fm.instancesettingstemplates.``FMSetupActionAddJDBCDriverDatabaseType`(*value*)

An enumeration.

* 
`mysql` *= 'mysql'*:

* 
`mssql` *= 'mssql'*:

* 
`oracle` *= 'oracle'*:

* 
`mariadb` *= 'mariadb'*:

* 
`snowflake` *= 'snowflake'*:

* 
`athena` *= 'athena'*:

* 
`bigquery` *= 'bigquery'*:
