# Govern Custom Pages Handler[¶](https://doc.dataiku.com/dss/latest/api/python/govern/govern-custom-pages-handler.html#govern-custom-pages-handler "Permalink to this headline")

Admins can manage custom pages.

## Retrieve the definition of a custom page[¶](https://doc.dataiku.com/dss/latest/api/python/govern/govern-custom-pages-handler.html#retrieve-the-definition-of-a-custom-page "Permalink to this headline")

§ import dataikuapi

§ host = "http(s)://DSS\_HOST:DSS\_PORT"

§ apiKey = "Your API key secret"

§ client = dataikuapi.GovernClient(host, apiKey)

§ # retrieve the custom pages handler

§ custom\_pages\_handler = client.get\_custom\_pages\_handler()

§ # get a custom page by its ID

§ custom\_page = custom\_pages\_handler.get\_custom\_page('cp.cust\_page\_1')

§ # get its definition

§ custom\_page\_def = custom\_page.get\_definition()

§ # print its definition

§ print(custom\_page\_def.get\_raw())

## Reference API doc[¶](https://doc.dataiku.com/dss/latest/api/python/govern/govern-custom-pages-handler.html#reference-api-doc "Permalink to this headline")

*class* `dataikuapi.govern.admin_custom_pages_handler.``GovernAdminCustomPagesHandler`(*client*)

Handle to edit the custom pages Do not create this directly, use `get\_custom\_pages\_handler()`

`list_custom_pages`()

List custom pages

* Returns: A list of custom pages

* Return type: list of `GovernAdminCustomPageListItem`

`get_custom_page`(*custom\_page\_id*)

Get a custom page

* Parameters: **custom\_page\_id** (*str*) – ID of the custom page to retrieve

* Returns: A custom page as an object

* Return type: `GovernAdminCustomPage`

`create_custom_page`(*new\_identifier*, *custom\_page*)

Create a custom page

* Parameters: * **new\_identifier** (*str*) – the new identifier for this custom page. Allowed characters are letters, digits, hyphen, and underscore.
* **custom\_page** (*dict*) – the custom page definition.

* Returns: the handle of the created custom page

* Return type: `GovernAdminCustomPage`

*class* `dataikuapi.govern.admin_custom_pages_handler.``GovernAdminCustomPageListItem`(*client*, *data*)

An item in a list of custom pages. Do not create this directly, use `list\_custom\_pages()`

`get_raw`()

Get the raw content of the custom page list item

* Returns: the raw content of the custom page list item as a dict

* Return type: dict

`to_custom_page`()

Gets the `GovernAdminCustomPage` corresponding to this custom page object

* Returns: the custom page object

* Return type: a `GovernAdminCustomPage`

*class* `dataikuapi.govern.admin_custom_pages_handler.``GovernAdminCustomPage`(*client*, *custom\_page\_id*)

A handle to interact with a custom page as an administrator. Do not create this directly, use `get\_custom\_page()`

`get_definition`()

Get the definition of the custom page, to modify the definition call `save()` on the returned object.

* Returns: A custom page definition as an object

* Return type: `GovernAdminCustomPageDefinition`

`delete`()

Delete the custom page

* Returns: None

*class* `dataikuapi.govern.admin_custom_pages_handler.``GovernAdminCustomPageDefinition`(*client*, *custom\_page\_id*, *definition*)

The definition of a custom page. Do not create this directly, use `get\_definition()`

`get_raw`()

Get the raw content of the custom page. This returns a reference to the custom page so changes made to the returned object will be reflected when saving.

* Return type: dict

`save`()

Save this settings back to the custom page.

* Returns: None
