# Govern Blueprints and Blueprint versions[¶](https://doc.dataiku.com/dss/latest/api/python/govern/govern-blueprints-blueprint-versions.html#govern-blueprints-and-blueprint-versions "Permalink to this headline")

Blueprint versions are templates describing the items in Dataiku Govern. Several blueprint versions are gathered within the same Blueprint which holds a logical concept. Note: to learn more about them, go to the Dataiku Govern definitions page.

## List all blueprints[¶](https://doc.dataiku.com/dss/latest/api/python/govern/govern-blueprints-blueprint-versions.html#list-all-blueprints "Permalink to this headline")

§ import dataikuapi

§ host = "http(s)://DSS\_HOST:DSS\_PORT"

§ apiKey = "Your API key secret"

§ client = dataikuapi.GovernClient(host, apiKey)

§ # List the blueprints for which the API key has access

§ client.list\_blueprints()

## Reference API doc[¶](https://doc.dataiku.com/dss/latest/api/python/govern/govern-blueprints-blueprint-versions.html#reference-api-doc "Permalink to this headline")

*class* `dataikuapi.govern.blueprint.``GovernBlueprintListItem`(*client*, *data*)

An item in a list of blueprints. Do not create this directly, use `list\_blueprints()`

`get_raw`()

Get the raw content of the blueprint list item

* Returns: the raw content of the blueprint list item as a dict

* Return type: dict

`to_blueprint`()

Gets the `GovernBlueprint` corresponding to this blueprint object

* Returns: the blueprint object

* Return type: a `GovernBlueprint`

*class* `dataikuapi.govern.blueprint.``GovernBlueprint`(*client*, *blueprint\_id*)

A handle to read a blueprint on the Govern instance. If you wish to edit blueprints or the blueprint versions, use  the blueprint designer object `GovernAdminBlueprintDesigner`. Do not create this directly, use `get\_blueprint()`

`get_definition`()

Return the definition of the blueprint as an object.

* Returns: The blueprint definition as an object.

* Return type: `GovernBlueprintDefinition`

`list_versions`()

List versions of this blueprint.

* Returns: the list of blueprint versions

* Return type: list of `GovernBlueprintVersionListItem`

`get_version`(*version\_id*)

Return a handle to interact with a blueprint version

* Parameters: **version\_id** (*str*) – ID of the version

* Return type: `GovernBlueprintVersion`

*class* `dataikuapi.govern.blueprint.``GovernBlueprintDefinition`(*client*, *blueprint\_id*, *definition*)

The definition of a blueprint. Do not create this class directly, instead use `get\_definition()`

`get_raw`()

Get raw definition of a blueprint

* Returns: The raw definition of blueprint, as a dict.

* Return type: dict

*class* `dataikuapi.govern.blueprint.``GovernBlueprintVersionListItem`(*client*, *blueprint\_id*, *data*)

An item in a list of blueprint versions. Do not create this directly, use `list\_versions()`

`get_raw`()

Get the raw content of the blueprint version list item

* Returns: the raw content of the blueprint version list item as a dict

* Return type: dict

`to_blueprint_version`()

Gets the `GovernBlueprintVersion` corresponding to this blueprint version object

* Returns: the blueprint object

* Return type: a `GovernBlueprintVersion`

*class* `dataikuapi.govern.blueprint.``GovernBlueprintVersion`(*client*, *blueprint\_id*, *version\_id*)

A handle to interact with a blueprint version on the Govern instance. Do not create this directly, use `get\_version()`

`get_blueprint`()

Retrieve the blueprint handle of this blueprint version.

* Returns: the corresponding blueprint handle

* Return type: `GovernBlueprint`

`get_trace`()

Get the trace of this blueprint version (info about its status and origin blueprint version lineage).

* Returns: The trace of this blueprint version.

* Return type: `GovernBlueprintVersionTrace`

`get_definition`()

Get the definition of this blueprint version.

* Returns: The definition of the blueprint version as an object.

* Return type: `GovernBlueprintVersionDefinition`

*class* `dataikuapi.govern.blueprint.``GovernBlueprintVersionTrace`(*client*, *blueprint\_id*, *version\_id*, *trace*)

The trace of a blueprint version containing information about its lineage and its status. Do not create this directly, use `get\_trace()`

`get_raw`()

Get raw trace of the blueprint version.

* Returns: The raw trace of blueprint version, as a dict.

* Return type: dict

*property* `status`

Get the status of the blueprint version among (DRAFT, ACTIVE, or ARCHIVED)

* Return type: str

*property* `origin_version_id`

Get the origin version ID of this blueprint version

* Return type: str

*class* `dataikuapi.govern.blueprint.``GovernBlueprintVersionDefinition`(*client*, *blueprint\_id*, *version\_id*, *definition*)

The definition of a blueprint version. Do not create this directly, use `get\_definition()`

`get_raw`()

Get raw definition of the blueprint version.

* Returns: The raw definition of blueprint version, as a dict.

* Return type: dict
