# Project libraries[¶](https://doc.dataiku.com/dss/latest/api/python/project-libraries.html#project-libraries "Permalink to this headline")

You can interact with the Library of each project through the API.

* Getting the DSSLibrary object

* Retrieving the content of a file

* Getting the list of all the library items

* Add a new folder in the library

* Add a new file in the library

* Rename a file or a folder in the library

* Move a file or a folder in the library

* Delete a file or a folder from the library

* Reference documentation

## Getting the DSSLibrary object[¶](https://doc.dataiku.com/dss/latest/api/python/project-libraries.html#getting-the-dsslibrary-object "Permalink to this headline")

You must first retrieve the `DSSLibrary` through the `get\_library()` method

§ project = client.get\_project("MYPROJECT")

§ library = project.get\_library()

## Retrieving the content of a file[¶](https://doc.dataiku.com/dss/latest/api/python/project-libraries.html#retrieving-the-content-of-a-file "Permalink to this headline")

§ library\_file = library.get\_file("/file.txt")

§ print("Content: %s" % library\_file.read()))

§ # Alternate ways to retrieve a file handle

§ library\_file = library.get\_file("/python/some\_code.py")

§ library\_file = library.get\_folder("/python").get\_file("/some\_code.py")

## Getting the list of all the library items[¶](https://doc.dataiku.com/dss/latest/api/python/project-libraries.html#getting-the-list-of-all-the-library-items "Permalink to this headline")

§ def print\_library\_items(item):

§ print(item.path)

§ if "list" in dir(item):

§ for child in item.list():

§ print\_library\_items(child)

§ for item in lib.list():

§ print\_library\_items(item)

## Add a new folder in the library[¶](https://doc.dataiku.com/dss/latest/api/python/project-libraries.html#add-a-new-folder-in-the-library "Permalink to this headline")

§ library.add\_folder("/new\_folder")

§ library.add\_folder("/python/new\_sub\_folder")

§ library.get\_folder("/python").add\_folder("another\_sub\_folder")

## Add a new file in the library[¶](https://doc.dataiku.com/dss/latest/api/python/project-libraries.html#add-a-new-file-in-the-library "Permalink to this headline")

§ # create a new file in a folder

§ file = open("/path/to/local/file")

§ library.put\_file("/new\_folder/file.txt", file)

## Rename a file or a folder in the library[¶](https://doc.dataiku.com/dss/latest/api/python/project-libraries.html#rename-a-file-or-a-folder-in-the-library "Permalink to this headline")

§ # rename a file in the library

§ library.get\_file("/folder/file.txt").rename("renamed\_file.txt")

§ # rename a folder in the library

§ library.get\_folder("/folder").rename("renamed\_folder")

## Move a file or a folder in the library[¶](https://doc.dataiku.com/dss/latest/api/python/project-libraries.html#move-a-file-or-a-folder-in-the-library "Permalink to this headline")

§ # move a file in the library

§ library.get\_file("/folder/file.txt").move\_to(library.get\_folder("/folder2"))

§ # move a folder in the library

§ library.get\_folder("/folder").move\_to(library.get\_folder("/folder2"))

## Delete a file or a folder from the library[¶](https://doc.dataiku.com/dss/latest/api/python/project-libraries.html#delete-a-file-or-a-folder-from-the-library "Permalink to this headline")

§ library.get\_file("/path/to/item").delete()

§ library.get\_folder("/path/to").get\_file("/item").delete()

## Reference documentation[¶](https://doc.dataiku.com/dss/latest/api/python/project-libraries.html#reference-documentation "Permalink to this headline")

*class* `dataikuapi.dss.projectlibrary.``DSSLibrary`(*client*, *project\_key*)

A handle to manage the library of a project It saves locally a copy of taxonomy to help navigate in the library All modifications done through this object and related library items are done locally and on remote. Note: Taxonomy modifications done outside this library are not reflected locally.

You should reload the library in this case.

`list`(*folder\_path='/'*)

Lists the contents in the given library folder or on the root if no folder is given. :param: str folder\_path: the folder path (optional). If no path is given, it is defaulted to the root path. :returns: the list of contents in the library folder :rtype: list of `dataikuapi.dss.projectlibrary.DSSLibraryItem`

`get_file`(*path*)

Retrieves a file in the library :param: str path: the file path :returns: the file in the given path :rtype: `dataikuapi.dss.projectlibrary.DSSLibraryFile`

`get_folder`(*path*)

Retrieves a folder in the library :param: str path: the folder path :returns: the folder in the given path :rtype: `dataikuapi.dss.projectlibrary.DSSLibraryFolder`

`add_file`(*file\_name*)

Create a file in the library root folder :param: str file\_name: the file name :returns: the new file :rtype: `dataikuapi.dss.projectlibrary.DSSLibraryFile`

`add_folder`(*folder\_name*)

Create a folder in the library root folder :param: str file\_name: the file name :returns: the new folder :rtype: `dataikuapi.dss.projectlibrary.DSSLibraryFolder`
