# Importing tables as datasets[¶](https://doc.dataiku.com/dss/latest/api/python/tables-import.html#importing-tables-as-datasets "Permalink to this headline")

The “import tables as datasets” feature is available through the API, both for Hive and SQL tables

## Importing SQL tables[¶](https://doc.dataiku.com/dss/latest/api/python/tables-import.html#importing-sql-tables "Permalink to this headline")

§ project = client.get\_project("MYPROJECT")

§ import\_definition = project.init\_tables\_import()

§ import\_definition.add\_sql\_table("my\_sql\_connection", "schema\_of\_the\_table", "name\_of\_the\_table")

§ prepared\_import = import\_definition.prepare()

§ future = prepared\_import.execute()

§ import\_result = future.wait\_for\_result()

## Importing Hive tables[¶](https://doc.dataiku.com/dss/latest/api/python/tables-import.html#importing-hive-tables "Permalink to this headline")

§ project = client.get\_project("MYPROJECT")

§ import\_definition = project.init\_tables\_import()

§ import\_definition.add\_hive\_table("hive\_database", "hive\_table\_name")

§ prepared\_import = import\_definition.prepare()

§ future = prepared\_import.execute()

§ import\_result = future.wait\_for\_result()

## Reference documentation[¶](https://doc.dataiku.com/dss/latest/api/python/tables-import.html#reference-documentation "Permalink to this headline")

*class* `dataikuapi.dss.project.``TablesImportDefinition`(*client*, *project\_key*)

Temporary structure holding the list of tables to import

`add_hive_table`(*hive\_database*, *hive\_table*)

Add a Hive table to the list of tables to import

* Parameters: * **hive\_database** (*str*) – the name of the Hive database
* **hive\_table** (*str*) – the name of the Hive table

`add_sql_table`(*connection*, *schema*, *table*)

Add a SQL table to the list of tables to import

* Parameters: * **connection** (*str*) – the name of the SQL connection
* **schema** (*str*) – the schema of the table
* **table** (*str*) – the name of the SQL table

`add_elasticsearch_index_or_alias`(*connection*, *index\_or\_alias*)

Add an Elastic Search index or alias to the list of tables to import

`prepare`()

Run the first step of the import process. In this step, DSS will check the tables whose import you have requested and prepare dataset names and target connections

* Returns: an object that allows you to finalize the import process

* Return type: `TablesPreparedImport`

*class* `dataikuapi.dss.project.``TablesPreparedImport`(*client*, *project\_key*, *candidates*)

Result of preparing a tables import. Import can now be finished

`execute`()

Starts executing the import in background and returns a `dataikuapi.dss.future.DSSFuture` to wait on the result

* Returns: a future to wait on the result

* Return type: `dataikuapi.dss.future.DSSFuture`
