# Setting up the API Deployer and deployment infrastructures[¶](https://doc.dataiku.com/dss/latest/apinode/installing-apideployer.html#setting-up-the-api-deployer-and-deployment-infrastructures "Permalink to this headline")

The API Deployer is part of the Deployer, so please follow the Deployer installation steps to be able to use the API Deployer.

You will then create API infrastructures.

## Create your first infrastructure[¶](https://doc.dataiku.com/dss/latest/apinode/installing-apideployer.html#create-your-first-infrastructure "Permalink to this headline")

The API Deployer manages several deployment infrastructures. You need to create at least one in order to be able to deploy models to the API deployer.

Possible infrastructure types are:

* A *static* infrastructure: a set of pre-deployed API nodes that the API Deployer manages.

* A *Kubernetes* infrastructure: the API Deployer dynamically creates containers in your Kubernetes cluster to run the API Node server.

### Static infrastructure[¶](https://doc.dataiku.com/dss/latest/apinode/installing-apideployer.html#static-infrastructure "Permalink to this headline")

* Install one or several API nodes as described in Installing API nodes

* For each API node, generate an admin key from the terminal: go to the API node’s DATA\_DIR and use `./bin/apinode-admin admin-key-create`

* Write down the key

On the API Deployer node:

* From the home page, go to the API Deployer > Infrastructures

* Create a new infrastructure with “static” type

* Go to the “API Nodes” settings page

* For each API node, enter its base URL (including protocol and port number) and the API key

Then, go to the “Permissions” tab and grant to some user groups the right to deploy models to this infrastructure.

Your infrastructure is ready to use, and you can create your first model: First API (with API Deployer)

### Kubernetes infrastructure[¶](https://doc.dataiku.com/dss/latest/apinode/installing-apideployer.html#kubernetes-infrastructure "Permalink to this headline")

Please see Deploying on Kubernetes

### Setting up stages[¶](https://doc.dataiku.com/dss/latest/apinode/installing-apideployer.html#setting-up-stages "Permalink to this headline")

Each infrastructure belongs to a “Lifecycle stage”. This is used in order to show deployments per lifecycle stage. DSS comes preconfigured with the classic “Dev”, “Test” and “Prod” stages but you can freely modify these stages in Administration > Settings > Deployer > API deployment stages
