# Application tiles[¶](https://doc.dataiku.com/dss/latest/applications/tiles.html#application-tiles "Permalink to this headline")

## Introduction[¶](https://doc.dataiku.com/dss/latest/applications/tiles.html#introduction "Permalink to this headline")

Application tiles are used to build the UI displayed to the users of an application.

## Tiles[¶](https://doc.dataiku.com/dss/latest/applications/tiles.html#tiles "Permalink to this headline")

### Upload file in dataset[¶](https://doc.dataiku.com/dss/latest/applications/tiles.html#upload-file-in-dataset "Permalink to this headline")

The **Upload file in dataset** tile allows to modify the configuration of an **Uploaded files** dataset. The available interactions are:

* **Go to dataset settings**: the tile gives access to the Settings tab of the selected dataset.

* **Only upload file**: the tile allows to select or delete files.

* **Upload file and automatically redetect format**: same as the **Only upload file** mode but also automatically detects the format.

* **Upload file and automatically redetect format and infer schema**: same as the **Upload file and automatically redetect format** mode but also automatically infers the schema.

### Edit dataset[¶](https://doc.dataiku.com/dss/latest/applications/tiles.html#edit-dataset "Permalink to this headline")

The **Edit dataset** tile allows to modify the configuration of an **Editable** dataset. The tile gives access to the Edit screen of the selected dataset.

### Edit dataset settings[¶](https://doc.dataiku.com/dss/latest/applications/tiles.html#edit-dataset-settings "Permalink to this headline")

The **Edit dataset settings** tile allows to modify the configuration of a dataset. The tile gives access to the Settings tab of the selected dataset.

### Select dataset files[¶](https://doc.dataiku.com/dss/latest/applications/tiles.html#select-dataset-files "Permalink to this headline")

The **Select dataset files** tile allows to modify the configuration of a **Filesystem** dataset. The available interactions are:

* **Go to dataset settings**: the tile gives access to the Settings tab of the selected dataset.

* **Only browse file**: the tile allows to browse and select a file.

* **Browse file and automatically redetect format**: same as the **Only browse file** mode but also automatically detects the format.

* **Browse file and automatically redetect format and infer schema**: same as the **Browse file and automatically redetect format** mode but also automatically infers the schema.

* **Modal to browse file and automatically redetect format and infer schema**: same as the **Browse file and automatically redetect format and infer schema** mode but the editor is displayed in a modal.

### Select SQL table[¶](https://doc.dataiku.com/dss/latest/applications/tiles.html#select-sql-table "Permalink to this headline")

The **Select SQL table** tile allows to modify the configuration of a **SQL table** dataset. The available interactions are:

* **Go to dataset settings**: the tile gives access to the Settings tab of the selected dataset.

* **Only browse table**: the tile allows to browse and select a file.

* **Browse table and automatically redetect schema**: same as the **Only browse table** mode but also automatically detects the schema.

* **Modal to browse table and automatically redetect schema**: same as the **Browse table and automatically redetect schema** mode but the editor is displayed in a modal.

### Upload file in folder[¶](https://doc.dataiku.com/dss/latest/applications/tiles.html#upload-file-in-folder "Permalink to this headline")

The **Upload file in folder** tile allows to modify the configuration of a **Managed folder**. The available interactions are:

* **Go to folder**: the tile gives access to the View tab of the selected folder.

* **Upload file**: the tile allows to select or delete files.

### Select folder files[¶](https://doc.dataiku.com/dss/latest/applications/tiles.html#select-folder-files "Permalink to this headline")

The **Select folder files** tile allows to modify the configuration of a **Managed folder**. The available interactions are:

* **Go to folder settings**: the tile gives access to the Settings tab of the selected folder.

* **Browser folder location**: the tile allows to browse and select the folder location.

* **Modal to browse folder location**: same as the **Browser folder location** mode but the editor is displayed in a modal.

### Edit project variables[¶](https://doc.dataiku.com/dss/latest/applications/tiles.html#edit-project-variables "Permalink to this headline")

The **Edit project variables** tile allows to modify the project variables. See Custom variables expansion.

#### Runtime interactions[¶](https://doc.dataiku.com/dss/latest/applications/tiles.html#runtime-interactions "Permalink to this headline")

The available interactions are:

* **Open modal to edit**: the editor is displayed in a modal.

* **Edit inline with explicit save**: the editor is inlined in the tile but changes are saved upon clicking on the **Save** button.

* **Edit inline with auto-save**: the editor is inlined in the tile and any change is saved.

#### Runtime form[¶](https://doc.dataiku.com/dss/latest/applications/tiles.html#runtime-form "Permalink to this headline")

The runtime form can either be fully generated by DSS or fully custom. Its capabilities, behavior and definition are exactly the same as forms of plugin components.

##### Auto-generated form[¶](https://doc.dataiku.com/dss/latest/applications/tiles.html#auto-generated-form "Permalink to this headline")

Auto-generated forms are made of the same parameters as auto-generated forms in plugin components:

* The corresponding **Auto-generated controls** JSON editor in the application designer allows to directly edit the **params** field described in Parameters.

* The corresponding project variable will be named after the **name** field of the parameter.

* To configure a dynamic select using python:

1. set **getChoicesFromPython** to **true**

2. click on **Use custom UI**

3. create a **do()** method in the **Python helper code** code editor that returns a dict with a key “choices” as described in the section **Dynamic select using python** of Parameters

##### Custom form[¶](https://doc.dataiku.com/dss/latest/applications/tiles.html#custom-form "Permalink to this headline")

Custom forms offer more control on the actual form presented to the user. They are defined as html and JS files like in plugin components:

* The **Python helper code** code editor allows to write the **do()** method as described in the **Fetching data for custom forms** section of Custom settings UI.

* The **Custom UI HTML** code editor allows to write the HTML template where the controller is defined in the Javascript code editor.

* The **Custom UI JS** code editor allows to write the Javascript where the Angular controller is added to the Angular module.

* The **Angular module** text input allows to specify the Angular module.

* As described in the documentation Custom settings UI, the parameter values, i.e. the values of the project variables, should be set in the object **config**.

### Run scenario[¶](https://doc.dataiku.com/dss/latest/applications/tiles.html#run-scenario "Permalink to this headline")

The **Run scenario** tile allows to run a selected **Scenario**.

### Propagate schema[¶](https://doc.dataiku.com/dss/latest/applications/tiles.html#propagate-schema "Permalink to this headline")

When changing the input datasets of a flow, columns are often changed. Either their type can change, or columns can appear or disappear. This implies that the definition recipes consuming these datasets no longer matches their inputs, and thus that the recipes may fail to run. User action is then needed to adjust the recipes, updating, adding or removing columns from their definitions. This change can be tedious when for example one column has to be added to all downstream recipes and datasets of a changed input dataset. DSS offer the Propagate schema tool on the flow in order to facilitate this chore. The **Propagate schema** tile of an application wraps this tool.

The tile can be set to only initiate a schema propagation, leading the application user to the flow and letting them accept each suggested change manually. The tile can also be run automatically, without user interaction. In the latter mode, the application designer can pre-define some actions to take on the recipes in the **Recipe update options**, and also define recipes to not take action on at all:

* “Excluded recipes” is a list of names of recipes that the propagation should simply not consider. The propagation will stop at this recipe and not proceed further. For example, model training recipes should generally be excluded.

* “Recipes marked as OK” is a list of names of recipes that the propagation can consider as fine. Since propagation relies on design-time inspection of the recipes, some recipe types, notably code-based recipes, can’t compute the schema of their outputs without running or potentially expensive computations; for such recipes, the propagation tool, when run interactively, will ask for the user to double-check manually and mark as OK. When marked as OK, the automatic propagation will not seek approval from the user and just continue the propagation

* “Partition by dimension” (name) and “Partition by computable” (name) offer control on the default values for partition identifiers to use when the propagation needs to rebuild a dataset to compute some schema change downstream, and that dataset is partitioned. This happens for example for Prepare recipes, which need their input to be up-to-date in order to compute a schema.

The **Recipe update options** is a JSON block of the following structure:

§ {

§ "byType" : {

§ "grouping" : {

§ // options for all grouping recipes

§ },

§ "window" : {

§ // options for all grouping recipes

§ },

§ "join" : {

§ // options for all join recipes

§ }

§ },

§ "byName" : {

§ "compute_some_data_by_key" : {

§ // options for the compute_some_data_by_key recipe

§ },

§ ...

§ }

§ }

#### Update options for Group[¶](https://doc.dataiku.com/dss/latest/applications/tiles.html#update-options-for-group "Permalink to this headline")

The options available are

§ {

§ "removeMissingAggregates" : true, // drop aggregates of columns no longer present in the input

§ "removeMissingKeys" : true, // drop columns no longer present in the input from the grouping keys

§ "newAggregates" : {

§ "DOUBLE" : [

§ {

§ "column" : "regular expression to filter columns",

§ // if match found, add the following aggregates

§ "min" : true,

§ "avg" : true

§ },

§ ...

§ ],

§ "BIGINT" : [

§ // rules for added columns of type bigint

§ ]

§ }

§ }

#### Update options for Window[¶](https://doc.dataiku.com/dss/latest/applications/tiles.html#update-options-for-window "Permalink to this headline")

Quite similarly to the Group recipe, the options available are

§ {

§ "removeMissingAggregates" : true, // drop aggregates of columns no longer present in the input

§ "removeMissingInWindow" : true, // drop columns no longer present in the input from the partitioning and sorting keys

§ "newAggregates" : {

§ "DOUBLE" : [

§ {

§ "column" : "regular expression to filter columns",

§ // if match found, add the following aggregates

§ "min" : true,

§ "last" : true

§ },

§ ...

§ ],

§ "BIGINT" : [

§ // rules for added columns of type bigint

§ ]

§ }

§ }

#### Update options for Join[¶](https://doc.dataiku.com/dss/latest/applications/tiles.html#update-options-for-join "Permalink to this headline")

The options available are

§ {

§ "removeMissingJoinConditions" : true, // drop join conditions involving columns no longer present in the input

§ "removeMissingJoinValues" : true, // drop columns no longer present in the input the list of selected columns

§ "newSelectedColumns" : {

§ "DOUBLE" : [

§ {

§ "table" : 1, // this rule applies to the second input only

§ "name" : "regular expression to filter columns"

§ // if match found, select the column

§ },

§ {

§ "table" : -1, // this rule applies to all inputs

§ "name" : "regular expression to filter columns",

§ "alias" : "alias for the added column, with $1, $2 ... replacements from the regex"

§ },

§ ...

§ ],

§ "BIGINT" : [

§ // rules for added columns of type bigint

§ ]

§ }

§ }

For example, the following rule matches columns ending in **\_min** and outputs them without the **\_min** suffix:

§ {

§ "table" : -1,

§ "name" : "^(.\*)\_min$",

§ "alias" : "$1"

§ }

### View dashboard[¶](https://doc.dataiku.com/dss/latest/applications/tiles.html#view-dashboard "Permalink to this headline")

The **View dashboard** tile allows to view a selected **Dashboard**.

### View folder[¶](https://doc.dataiku.com/dss/latest/applications/tiles.html#view-folder "Permalink to this headline")

The **View folder** tile allows to access the View tab of the selected **Managed Folder**.

### Download dataset[¶](https://doc.dataiku.com/dss/latest/applications/tiles.html#download-dataset "Permalink to this headline")

The **Download dataset** tile allows to download the selected **Dataset**.

### Download report[¶](https://doc.dataiku.com/dss/latest/applications/tiles.html#download-report "Permalink to this headline")

The **Download report** tile allows to download the selected **R Markdown report**.

### Download file[¶](https://doc.dataiku.com/dss/latest/applications/tiles.html#download-file "Permalink to this headline")

The **Download file** tile allows to download the selected file or folder from the selected **Managed folder**.

### Download dashboard[¶](https://doc.dataiku.com/dss/latest/applications/tiles.html#download-dashboard "Permalink to this headline")

The **Download dashboard** tile allows to download the selected **Dashboard**. See Exporting dashboards to PDF or images.

### Variable display[¶](https://doc.dataiku.com/dss/latest/applications/tiles.html#variable-display "Permalink to this headline")

The **Variable display** tile allows to display variable. The display can be customized using HTML tags. As described in Custom variables expansion variables must be reference with the **${variable\_name}** syntax.
