# MySQL[¶](https://doc.dataiku.com/dss/latest/connecting/sql/mysql.html#mysql "Permalink to this headline")

Note

You might want to start with our detailed tutorial for your first steps with SQL databases in DSS.

You might want to start with that tutorial. The rest of this page is reference information for MySQL.

DSS supports the full range of features on MySQL:

* Reading and writing datasets

* Executing SQL recipes

* Performing visual recipes in-database

* Using live engine for charts

## Caveats[¶](https://doc.dataiku.com/dss/latest/connecting/sql/mysql.html#caveats "Permalink to this headline")

* TZ issue

## Installing the driver[¶](https://doc.dataiku.com/dss/latest/connecting/sql/mysql.html#installing-the-driver "Permalink to this headline")

* Download the driver from https://dev.mysql.com/downloads/connector/j/

* Unzip the resulting file

* Install the JAR file in DSS as explained in /connecting/sql

## Secure connections (SSL / TLS) support[¶](https://doc.dataiku.com/dss/latest/connecting/sql/mysql.html#secure-connections-ssl-tls-support "Permalink to this headline")

DSS can connect to a MySQL server using secure connections.

### Importing the server certificate and creating the client certificate[¶](https://doc.dataiku.com/dss/latest/connecting/sql/mysql.html#importing-the-server-certificate-and-creating-the-client-certificate "Permalink to this headline")

Please follow the instructions laid out here:

https://dev.mysql.com/doc/connector-j/5.1/en/connector-j-reference-using-ssl.html

You may need to add the root certificate of the authority which issued the MySQL server certificate to the JVM truststore using one of the procedures described at Adding SSL certificates to the Java truststore.

Additionally, if a client certificate is used, the keystore file and password used by DSS to authenticate to the MySQL server need to be specified with additional Java options `-Djavax.net.ssl.keyStore=path\_to\_keystore\_file -Djavax.net.ssl.keyStorePassword=password`.

Your install.ini file should therefore look like:

§ [javaopts]

§ backend.additional.opts=-Djavax.net.ssl.keyStore=path_to_keystore_file -Djavax.net.ssl.keyStorePassword=password -Djavax.net.ssl.trustStore=path_to_truststore_file -Djavax.net.ssl.trustStorePassword=password

§ jek.additional.opts=-Djavax.net.ssl.keyStore=path_to_keystore_file -Djavax.net.ssl.keyStorePassword=password -Djavax.net.ssl.trustStore=path_to_truststore_file -Djavax.net.ssl.trustStorePassword=password

§ fek.additional.opts=-Djavax.net.ssl.keyStore=path_to_keystore_file -Djavax.net.ssl.keyStorePassword=password -Djavax.net.ssl.trustStore=path_to_truststore_file -Djavax.net.ssl.trustStorePassword=password

### Setting up the MySQL connection[¶](https://doc.dataiku.com/dss/latest/connecting/sql/mysql.html#setting-up-the-mysql-connection "Permalink to this headline")

In the settings of the connection, add an “Advanced property”:

* Key: `useSSL`

* Value: `true`
