# Dashboard concepts[¶](https://doc.dataiku.com/dss/latest/dashboards/concepts.html#dashboard-concepts "Permalink to this headline")

## Dashboards, tiles and insights[¶](https://doc.dataiku.com/dss/latest/dashboards/concepts.html#dashboards-tiles-and-insights "Permalink to this headline")

A DSS project contains multiple dashboards. Each dashboard is made of multiple slides. On each slide, you put tiles.

There are three kinds of tiles:

* “Simple” tiles (static text, image, embedded page)

* “Insight” tiles. Each of this tiles displays a single insight.

* “Filter” tiles. A filter tile can be used to filter all chart and dataset insights on a slide.

### Insights[¶](https://doc.dataiku.com/dss/latest/dashboards/concepts.html#insights "Permalink to this headline")

An insight is a piece of information that can be shared on a dashboard. There are many kinds of insights:

* A dataset, as a tabular representation

* A chart

* The report of a machine learning model

* The contents of a DSS managed folder

* A DSS metric

* The report of a scenario

* A button to run a scenario

* An export from a Jupyter notebook

* The display of a webapp

* Activity & comments feed of any DSS object

* Activity summary reports of a DSS project

* A button to run a DSS macro

Each insight lives independently from dashboards and can be attached on multiple dashboards. By default, DSS always creates new insights when adding something to the dashboard, but you can also choose to reattach an existing insight.

Most insights *reference* DSS objects:

* A dataset table references a dataset

* A chart references a dataset

* A machine learning model report references the machine learning model

* A DSS metric insights references a dataset, model or folder

Security is carried by the referenced objects, through the Workspace & Dashboard authorizations mechanism. In other words, if a dataset is workspace/dashboard authorized, then the dashboard-only users of the project will be able to create dataset table, charts and comments insights based on this dataset; workspace users will be able to view the dataset and any insights that reference it.

Insights live independently from their referenced objects. In most cases, modifying anything on the insight will either be impossible, or will not reflect in the original object.

When you are on the dashboard, you can go to a full-size view of the insight by clicking on the Go button

### Filter tiles[¶](https://doc.dataiku.com/dss/latest/dashboards/concepts.html#filter-tiles "Permalink to this headline")

A filter tile can be used to filter all chart and dataset insights on a slide. To learn more about filters tile, see <filters>.

## Permissions[¶](https://doc.dataiku.com/dss/latest/dashboards/concepts.html#permissions "Permalink to this headline")

### Owners[¶](https://doc.dataiku.com/dss/latest/dashboards/concepts.html#owners "Permalink to this headline")

Each dashboard (and each insight) has an owner, who is the person who created this dashboard (resp insight).

The following people (apart from the owner) can modify a dashboard created by a given user:

* People who have “Write Dashboard” access to the project (See Main project permissions)

* DSS administrators

### Dashboard visibility[¶](https://doc.dataiku.com/dss/latest/dashboards/concepts.html#dashboard-visibility "Permalink to this headline")

Everybody who has “Read dashboards” permission to the project can view a dashboard, regardless of who created it: dashboards don’t carry access restrictions. However, by default, dashboards are unpromoted. An unpromoted dashboard is readable but not visible to users with “Read dashboards”.

To view an unpromoted dashboard, you need to know its URL. This makes it easy to share dashboards with colleagues by sending them the URL. People who have “Write dashboards” permission on the project can see and edit all dashboards in the list (even unpromoted ones of which they are not the owner). They can also promote a dashboard and make it visible to “Read dashboards” users.

### Editing the dashboard as an analyst[¶](https://doc.dataiku.com/dss/latest/dashboards/concepts.html#editing-the-dashboard-as-an-analyst "Permalink to this headline")

When you have “Read project content” on the project, you may add every item to the dashboard, not only items which are previously dashboard-authorized.

Each time you add an item to the dashboard (either directly from the item, or from the dashboard), if this object is not already in the dashboard authorizations, you will get a warning that dashboard-only users will not be able to see this insight, since the source is not dashboard-authorized.

* If you have “Manage authorized objects” permission, you’ll get a prompt to add it automatically

* If you don’t have “Manage authorized objects” permission, you’ll only have a warning indicating that you must ask your project administrator
