# Deployment infrastructures[¶](https://doc.dataiku.com/dss/latest/deployment/project-deployment-infrastructures.html#deployment-infrastructures "Permalink to this headline")

The Project Deployer manages several deployment infrastructures, which are Automation nodes. You need to create at least one in order to deploy projects.

## Setting up automation nodes (Custom Dataiku)[¶](https://doc.dataiku.com/dss/latest/deployment/project-deployment-infrastructures.html#setting-up-automation-nodes-custom-dataiku "Permalink to this headline")

You will need to install one or several Automation nodes. Please see Installing an automation node

Then for each Automation node, go to Administration > Security > Global API keys and generate a new API key. This key must have global admin privileges. Take note of the secret.

## Setting up automation nodes (Dataiku Cloud Stacks)[¶](https://doc.dataiku.com/dss/latest/deployment/project-deployment-infrastructures.html#setting-up-automation-nodes-dataiku-cloud-stacks "Permalink to this headline")

Simply start new Automation instances

## Setting up automation nodes (Dataiku Online)[¶](https://doc.dataiku.com/dss/latest/deployment/project-deployment-infrastructures.html#setting-up-automation-nodes-dataiku-online "Permalink to this headline")

You only need to activate your Automation node in the Launchpad > Extension Tab > Add an extension > Automation node.

The installation and setup will be automatically done without needing further actions from you.

## Setting up users[¶](https://doc.dataiku.com/dss/latest/deployment/project-deployment-infrastructures.html#setting-up-users "Permalink to this headline")

The whole security mechanism of the Deployer is based on the *matching of user logins* between the various nodes. It is thus critical that the same users with the same logins exist on the Deployer and Automation nodes. Otherwise, your Deployer users won’t be able to deploy to the Automation node.

You therefore need to set up users’ access on the Deployer in a similar fashion to your Automation nodes.

If you are using LDAP logins for your Automation nodes, remember that the default behavior is to import users dynamically from LDAP the first time they connect to DSS (provided that they belong to an authorized group). This import is only done when logging on to the DSS node. Thus, before being able to push services to the Deployer, users will need to log in at least once on the Deployer node.

## Setup infrastructures on the Deployer[¶](https://doc.dataiku.com/dss/latest/deployment/project-deployment-infrastructures.html#setup-infrastructures-on-the-deployer "Permalink to this headline")

Note

If you are using Dataiku Cloud Stacks, and have enabled fleet management on your virtual network, this is done automatically, you don’t need to do these operations.

On the Project Deployer:

* From the home page, go to Project Deployer > Infrastructures

* Create a new infrastructure with a unique ID

* Enter the Automation node’s base URL (including protocol and port number) and the API key secret

* Go to the “Settings” tab and grant to some user groups the right to deploy projects to this infrastructure

* Repeat for all Automation nodes

Your infrastructure(s) is ready to use, and you can create your first bundle: Creating a bundle

## Setting up stages[¶](https://doc.dataiku.com/dss/latest/deployment/project-deployment-infrastructures.html#setting-up-stages "Permalink to this headline")

Each infrastructure belongs to a “lifecycle stage”. This is used to show the deployments per lifecycle stage. DSS comes preconfigured with the classic “Dev”, “Test” and “Prod” stages but you can freely modify these stages in Administration > Settings > Deployer > Project deployment stages.
