# Blueprint Designer[¶](https://doc.dataiku.com/dss/latest/governance/blueprint-designer.html#blueprint-designer "Permalink to this headline")

* Overview

* Using Blueprint Designer

+ Creating and designing a blueprint version

+ General settings

+ Fields

+ Views & View components

+ Hooks

## Overview[¶](https://doc.dataiku.com/dss/latest/governance/blueprint-designer.html#overview "Permalink to this headline")

The Blueprint Designer allows Admin users to create new blueprints to use within Dataiku Govern. Blueprints are the templates that are applied to objects (such as business inititatives, projects, bundles, models, and model versions) when they are Governed. Blueprints can also be created for new types of objects you might want to use in Govern, for example a risk analysis or a non-DSS project workflow.

The blueprint determines what information is collected and stored about that object. For example, a project from a Design node can be Governed using a Govern Project blueprint. The blueprint defines which fields can be filled in and seen by users, and what the workflow looks like. You can have multiple versions of Blueprints to allow for different needs (for example, blueprint versions for a “North America Govern Project” and an “EU Govern Project”, which can be applied when governing projects as appropriate).

Modifying blueprint designs allows you to edit the steps in your workflows and the relevant fields, with various input types available. Fields can also be linked together as references to other artifacts or by using formulas to determine some fields based on others.

## Using Blueprint Designer[¶](https://doc.dataiku.com/dss/latest/governance/blueprint-designer.html#using-blueprint-designer "Permalink to this headline")

The Blueprint Designer contains a blueprint for each default Govern object (business inititatives, projects, bundles, models, and model versions). Each blueprint can have as many versions as desired.

It’s also possible to create new types of blueprints that aren’t related to Dataiku objects, if you want to track other types of information or workflows in Dataiku Govern.

Blueprint versions can either be “Draft”, “Active”, or “Archived” - they must be set to Active they can be actually used in Govern.

### Creating and designing a blueprint version[¶](https://doc.dataiku.com/dss/latest/governance/blueprint-designer.html#creating-and-designing-a-blueprint-version "Permalink to this headline")

A blueprint version is always created inside a blueprint. It can be a new blueprint, or an existing one. When creating a new blueprint version, you can create a blank template, create a copy of an existing blueprint version, or import a file (for example, from another Govern node, or a blueprint version provided by Dataiku). Concerning blueprint versions that are used to govern objects, it is **strongly** advised to start from a copy of an existing blueprint version, because some fields and workflow steps are required to properly work (sign off for deployments, reviewers settings, etc.)

When designing a blueprint versions, you can start by defining how many steps are in the workflow (if a workflow is desired).

Then the next step is to define which Fields you’d like to include on that blueprint. These will be the fields that Govern users will fill in, or view, to see information about the objects to which this blueprint has been applied.

Next, you will define Views, which are the collection of fields that the users will see and interact with. For example, you might create a “Project Description” field and a “Status Update” field. Then you create a “Overview” view which includes “Project Description” and a “Step 1” view that includes “Status Update”.

Finally, you apply the Views to the relevant places, either the main page or the steps you’ve created in the workflow, by adding the View ID.

### General settings[¶](https://doc.dataiku.com/dss/latest/governance/blueprint-designer.html#general-settings "Permalink to this headline")

The General section allows you to define some key information for your blueprint version.

Under “Main” you can add some instructions for other users, define the Parent (which is used to define the hierarchy of your blueprints for breadcrumbs for users), and set which View should be used on the main page of any objects using this blueprint (see “Views”, below - once you’ve made the View as described in that section, add the ID of that view on this page).

Under “Workflow” you can create steps for a workflow, if desired (leave this empty if you want to make a blueprint with no workflow). You can name and re-order your steps, specify which View ID should be used for each step (again, see “Views” below), or assign one or more of the steps to require a formal sign off.

When making a step a “sign off” step, you can use the sign off editor to define who is responsible for signing off in that step for any objects that use this blueprint version.

### Fields[¶](https://doc.dataiku.com/dss/latest/governance/blueprint-designer.html#fields "Permalink to this headline")

Fields can be defined which contain information and can accept user inputs. Fields can be of the following types:

* Number

* Boolean (creates a checkbox users can mark)

* Text

* Category (you define the options that users choose from in a drop down list)

* Date

* Reference (which reference another artifact in Dataiku Govern, for example a specific governed Project)

* File (allows users to upload a file)

* Time Series (this is currently mainly used for models metrics graph, a field from this type cannot be edited directly from the GUI, only through the public API, or in a hook)

To edit (or view) these fields, users will need to have Write (or Read) permission for that blueprint or field.

Some constraints may be defined on fields depending on their type. For instance, a Number field can be constrained for its value to be only on an allowed range. A Reference field can be constrained on which allowed blueprints the reference item must be. Fields can also be defined as “required”. The “is List” checkbox allows users to add multiple values in a single field.

### Views & View components[¶](https://doc.dataiku.com/dss/latest/governance/blueprint-designer.html#views-view-components "Permalink to this headline")

As explained in the previous section, a field is akin to a variable which stores a value of a specific type. In order to display or edit a field value on the object page, the field must be embedded in a graphical element. We call such an element, a view component.

Below is the comprehensive list of all view components in Govern for Read and Edit mode.

| Field type | Read mode | Edit mode |

| --- | --- | --- |

| Number |  |  |

| Boolean |  |  |

| Text |  |  |

| Category |  |  |

| Date |  |  |

| Reference |  |  |

| File |  |  |

| Time Serie |  |  |

Views are a collection of view components that is aimed for a single purpose. For example, you can define a view for the Overview tab of an artifact (we call it the Main view), and one view for each step in a workflow. Once these views are created, users with appropriate permissions can input information into the fields in those views and read the information available from those fields.

The same Field can be added to multiple Views, for example if you want the relevant piece of information to appear on the Main view and on a workflow step. If a Field is used in multiple Views, if it is modified in any View, it will be changed in all of them.

Views come in two different layouts, Row and Card.

“Row” views are used as rows in tables.

“Card” views are used for all the other usages: in the Overview tab, in the Workflow steps, and in Reference fields.

When creating card views, you can add a single field in it or you can start by adding a container which will allow you to group fields together (“Add View Component” > at the top, change “Type” to “Container”). Then, you can add one or more fields to the container. You can also group fields together in separate groups by creating more containers within the top-level container.

As you’re adding fields to your view, use the three dot menu button on the right side of each field to add or delete fields. You can also rearrange the order using the three horizontal line button on each field listed in your view.

### Hooks[¶](https://doc.dataiku.com/dss/latest/governance/blueprint-designer.html#hooks "Permalink to this headline")

Hooks are used to automate actions related to artifacts in Dataiku Govern. They are written in Python and will be run during the artifacts lifecycle phases: CREATE, UPDATE, or DELETE. Which phases are selected to run a hook is configurable.

When you first create a hook, sample code will be included to demonstrate the available functionality. Some examples of how hooks can be used includes calculating a field based on other fields (for example, if you want to calculate a “risk score” based on inputs in a few different fields), or changing the owner of a project based on some criteria, or updating or creating an artifact based on some progress in a specific project or model.
