# Time Series Forecasting Results[¶](https://doc.dataiku.com/dss/latest/machine-learning/time-series-forecasting/results.html#time-series-forecasting-results "Permalink to this headline")

When a model finishes training, click on the model to see the results.

* Visualization

* Performance: Metrics

* Model Information: Algorithm

## Visualization[¶](https://doc.dataiku.com/dss/latest/machine-learning/time-series-forecasting/results.html#visualization "Permalink to this headline")

The model report contains a visualization of the time series forecast vs. the ground truth of the target variable. If quantiles were specified, this graph also contains the forecast intervals.

For multiple time series datasets, one visualization per time series is provided.

If K-Fold cross-test is used for evaluation, the forecast and forecast intervals are shown for every fold.

## Performance: Metrics[¶](https://doc.dataiku.com/dss/latest/machine-learning/time-series-forecasting/results.html#performance-metrics "Permalink to this headline")

DSS shows aggregated metrics, as well as per time series metrics for multiple time series datasets.

Aggregation methods by metric[¶](https://doc.dataiku.com/dss/latest/machine-learning/time-series-forecasting/results.html#id1 "Permalink to this table")

| Metric | Aggregation method |

| --- | --- |

| Mean Absolute Scaled Error (MASE) | Average across all timeseries |

| Mean Absolute Percentage Error (MAPE) | Average across all timeseries |

| Symmetric MAPE | Average across all timeseries |

| Mean Squared Error (MSE) | Average across all timeseries |

| Mean Scaled Interval Score (MSIS) | Average across all timeseries |

| Mean Absolute Quantile Loss (MAQL) | First compute the mean of each quantile loss across time series then compute the mean across all quantiles |

| Mean Weighted Quantile Loss (MWQL) | First compute the mean of each quantile loss across time series then compute the mean across all quantiles. Finally divide by the sum of the absolute target value across all time series |

| Root Mean Squared Error (RMSE) | Square-root of the aggregated Mean Squared Error (MSE) |

| Normalized Deviation (ND) | Sum of the absolute error across all time series, divided by the sum of the absolute target value across all time series |

## Model Information: Algorithm[¶](https://doc.dataiku.com/dss/latest/machine-learning/time-series-forecasting/results.html#model-information-algorithm "Permalink to this headline")

For multiple time series datasets, some models train one algorithm per time series under the hood (mainly ARIMA and Seasonal LOESS). The resulting per times series hyperparameters are shown in this tab, if any.
