# Using image features[¶](https://doc.dataiku.com/dss/latest/machine_learning/deep-learning/images.html#using-image-features "Permalink to this headline")

It is possible to handle images using DSS deep learning. To do so, you must store your images in a managed folder (See Managed folders).

Then, you need to indicate in the dataset that will be used for running the analysis the location of your images. Create a new column containing the relative path of each image inside the managed folder. Then, in the “Features handling” tab of the analysis, select “Image” as type for this column.

You need to precise the managed folder where the images are stored in Image location, and to do a Custom preprocessing that looks like:

§ from tensorflow.keras.applications.imagenet\_utils import preprocess\_input

§ from dataiku.doctor.deep\_learning.keras\_utils import load\_img

§ # This will give you an input shape of (197, 197, 3)

§ def preprocess\_image(image\_file):

§ # resized\_dims - an optional resizing step

§ # channels - 'L', 'RGB' or 'CMYK'

§ # data\_format - 'channels\_last' or 'channels\_first'

§ array = load\_img(image\_file, resized\_dims=(197, 197), channels='RGB', data\_format='channels\_last')

§ # You can use your own preprocessing, here for example we use tensorflow's out of the box one

§ array = preprocess\_input(array, mode='tf')

§ return array

where we see that the output for an image has a (197, 197, 3) shape. Then, this outptut is sent to a image\_path\_preprocessed input (if the name of the original column was image\_path), so the corresponding input in the model should look like:

§ input\_img = Input(shape=(197, 197, 3), name="image\_path\_preprocessed")

See Deep learning for image classification for a step-by-step example of this in practice.

## Scoring images[¶](https://doc.dataiku.com/dss/latest/machine_learning/deep-learning/images.html#scoring-images "Permalink to this headline")

When using a saved model that has image feature(s) for scoring, you can provide in the corresponding column(s):

* the relative path to the image, which must be stored in the **same** managed folder that was used for training

* a string that is the Base64 representation of the image file.
