# Time Series Forecasting Settings[¶](https://doc.dataiku.com/dss/latest/machine_learning/time-series-forecasting/settings.html#time-series-forecasting-settings "Permalink to this headline")

The “Settings” tab allows you to fully customize all aspects of your time series forecasting task.

* Settings: General settings

* Settings: Train / Test set

* Settings: External features

* Settings: Algorithms

## Settings: General settings[¶](https://doc.dataiku.com/dss/latest/machine_learning/time-series-forecasting/settings.html#settings-general-settings "Permalink to this headline")

Set the base settings for time series forecasting (target variable, time variable, time series identifiers (if multiple time series in the dataset))

### Time step parameters[¶](https://doc.dataiku.com/dss/latest/machine_learning/time-series-forecasting/settings.html#time-step-parameters "Permalink to this headline")

Define what time step will be used for time series resampling. Indeed, forecasting models require the dataset to be sampled with equally spaced time steps. A default setting is guessed by DSS, based on the input data.

### Forecasting parameters[¶](https://doc.dataiku.com/dss/latest/machine_learning/time-series-forecasting/settings.html#forecasting-parameters "Permalink to this headline")

Specify how many time steps will be forecast by the models (a.k.a forecasting horizon), as well as the number of skipped time steps for model evaluation (a.k.a gap).

You can also choose what quantiles will be forecasted by the models (also used for some evaluation metrics).

### Partitioned Models[¶](https://doc.dataiku.com/dss/latest/machine_learning/time-series-forecasting/settings.html#partitioned-models "Permalink to this headline")

Warning

DSS support for partitoned time series forecasting models is experimental

This allows you to train partitioned prediction models on partitioned datasets. In that case, DSS creates one sub model (or model partition) per partition of your dataset.

For more information, see Partitioned Models

## Settings: Train / Test set[¶](https://doc.dataiku.com/dss/latest/machine_learning/time-series-forecasting/settings.html#settings-train-test-set "Permalink to this headline")

When training a model, it is important to test the performance of the model on a “test set”. During the training phase, DSS “holds out” on the test set, and the model is only trained on the train set.

Once the model is trained, DSS evaluates its performance on the test set. This ensures that the evaluation is done on data that the model has “never seen before”.

### Splitting the dataset[¶](https://doc.dataiku.com/dss/latest/machine_learning/time-series-forecasting/settings.html#splitting-the-dataset "Permalink to this headline")

By default, DSS splits the input dataset (sorted by time) into a train and a test set. For time series forecasting, the size of the test set is the number of step in the forecasting horizon, minus the number of skipped steps (a.k.a gap).

#### Subsampling[¶](https://doc.dataiku.com/dss/latest/machine_learning/time-series-forecasting/settings.html#subsampling "Permalink to this headline")

DSS defaults to using the first 100’000 rows of the dataset, but other options are available.

For more details, see the documentation on Sampling.

#### K-Fold cross-test[¶](https://doc.dataiku.com/dss/latest/machine_learning/time-series-forecasting/settings.html#k-fold-cross-test "Permalink to this headline")

A variant of the single train/test split method is called “K-Fold cross-test”: DSS uses the last forecasting horizon as a test set (while skipping the gap), and all time steps before as a train set. It then shifts the test set backwards by one forecasting horizon, and takes all time steps before as a train set. This is repeated until we have **K** {train, gap, test} sets, or evaluation folds.

This method strongly increases training time (roughly speaking, it multiplies it by **K**). However, it allows for two interesting features:

* It provides a more accurate estimation of model performance, by averaging over K estimations (one per split) and by providing “error margins” on the performance metrics, computed as twice the standard deviation over the K estimations. When K-Fold cross-test is enabled, all performance metrics will have tolerance information.

* Once the scores have been computed on each fold, DSS can retrain the model on 100% of the dataset’s data. This is useful if you don’t have much training data.

### Time series resampling[¶](https://doc.dataiku.com/dss/latest/machine_learning/time-series-forecasting/settings.html#time-series-resampling "Permalink to this headline")

As mentioned above, forecasting models require the dataset to be sampled with equally spaced time steps.

To do so, DSS needs to impute missing values for missing time steps in the dataset. You can set which method to use for numerical and non-numerical features interpolation (missing time steps in the middle of the time series) and extrapolation (missing time steps before the start, or after the end of the time series).

A few example of imputation methods are: linear, quadratic, cubic, mean, constant value, same as previous/next/nearest, most common (for non-numerical), or no imputation at all.

## Settings: External features[¶](https://doc.dataiku.com/dss/latest/machine_learning/time-series-forecasting/settings.html#settings-external-features "Permalink to this headline")

Note

Some models do not support the usage of external features for time series forecasting

Warning

If external features are selected, “future” values of those features are required when forecasting.

While time series forecasting model can only work with a time variable and a target variable, having external time-dependent features can improve some models’ performance. You can select those that should be used by the model, along with handling settings for each.

See Features handling

## Settings: Algorithms[¶](https://doc.dataiku.com/dss/latest/machine_learning/time-series-forecasting/settings.html#settings-algorithms "Permalink to this headline")

DSS supports several algorithms that can be used to train time series forecasting models. We recommend trying several different algorithms before deciding on one particular modeling method.

See Time series forecasting algorithms for details.
