# Extensions[¶](https://doc.dataiku.com/dss/latest/mlops/experiment-tracking/extensions.html#extensions "Permalink to this headline")

Dataiku’s experiment tracking features *extensions* to the MLflow Python API.

Some of those extensions are allowing actions that can only be performed through the CLI in standard MLflow.

In order to interact with these extensions, you must first obtain a reference to the `dataikuapi.dss.mlflow.DSSMLflowExtension` through `dataikuapi.dss.project.DSSProject.get\_mlflow\_extension()`

§ import dataiku

§ import mlflow

§ project = dataiku.api\_client().get\_default\_project()

§ mlflow\_extension = project.get\_mlflow\_extension()

You can then use the following methods:

* list models and experiments: `dataikuapi.dss.mlflow.DSSMLflowExtension.list\_models()` and `dataikuapi.dss.mlflow.DSSMLflowExtension.list\_experiments()`

* rename experiments: `dataikuapi.dss.mlflow.DSSMLflowExtension.rename\_experiment()`

* restore experiments and runs: `dataikuapi.dss.mlflow.DSSMLflowExtension.restore\_experiment()` and `dataikuapi.dss.mlflow.DSSMLflowExtension.restore\_run()`

* clear experiments marked for deletion (*garbage collect*): `dataikuapi.dss.mlflow.DSSMLflowExtension.garbage\_collect()`

Others are more DSS specific:

* clean the runtime experiment db for a DSS project: `dataikuapi.dss.mlflow.DSSMLflowExtension.clean\_experiment\_tracking\_db()`

* set the inference info of a run (to make scoring or evaluation of a model easier): `dataikuapi.dss.mlflow.DSSMLflowExtension.set\_run\_inference\_info()`

* create a DSS dataset of the experiment tracking runs of a project: `dataikuapi.dss.mlflow.DSSMLflowExtension.create\_experiment\_tracking\_dataset()`

* deploy a model from a run: `dataikuapi.dss.mlflow.DSSMLflowExtension.deploy\_run\_model()`
