# Tracking experiments in code[¶](https://doc.dataiku.com/dss/latest/mlops/experiment-tracking/tracking.html#tracking-experiments-in-code "Permalink to this headline")

* Initial setup

* Quick start sample

* Tracking API

* Autologging

* Other topics

+ Logging into another project

+ Experiment tracking outside DSS

+ Usage without context manager

+ Cautions

+ Supported versions

## Initial setup[¶](https://doc.dataiku.com/dss/latest/mlops/experiment-tracking/tracking.html#initial-setup "Permalink to this headline")

Before you can track experiments, you need to create a Managed Folder in the project. The managed folder will be used to store artefacts. Take note of the managed folder id (8 alphanum characters, visible in the URL).

## Quick start sample[¶](https://doc.dataiku.com/dss/latest/mlops/experiment-tracking/tracking.html#quick-start-sample "Permalink to this headline")

§ import dataiku

§ import mlflow

§ project = dataiku.api\_client().get\_default\_project()

§ managed\_folder = project.get\_managed\_folder('A\_MANAGED\_FOLDER\_ID')

§ with project.setup\_mlflow(managed\_folder=managed\_folder) as mlflow:

§ # Note: if you don't call this (i.e. when no experiment is specified), the default one is used

§ mlflow.set\_experiment("My first experiment")

§ with mlflow.start\_run(run\_name="my\_run"):

§ # ...your MLflow code...

§ mlflow.log\_param("a", 1)

§ mlflow.log\_metric("b", 2)

§ # This uses the regular MLflow APIs

## Tracking API[¶](https://doc.dataiku.com/dss/latest/mlops/experiment-tracking/tracking.html#tracking-api "Permalink to this headline")

DSS uses the MLflow Tracking API. Please refer to the MLflow Tracking documentation.

## Autologging[¶](https://doc.dataiku.com/dss/latest/mlops/experiment-tracking/tracking.html#autologging "Permalink to this headline")

MLflow Tracking comes with a very useful feature: autologging, which automatically logs metrics, parameters, and models for common machine-learning packages without the need for explicit log statements.

Leveraging MLflow autologging requires no additional configuration of the DSS integration. Some machine learning packages, such as PyTorch, may however require additional packages.

In the following sample, we activate MLflow autologging for a SKlearn model. Metrics and artifacts are automatically logged.

§ import dataiku

§ import mlflow

§ import sklearn.linear\_model.ElasticNet

§ project = dataiku.api\_client().get\_default\_project()

§ managed\_folder = project.get\_managed\_folder('A\_MANAGED\_FOLDER\_ID')

§ with project.setup\_mlflow(managed\_folder=managed\_folder) as mlflow:

§ mlflow.set\_experiment("Let's autolog")

§ # activate Mflow autologging

§ mlflow.sklearn.autolog()

§ with mlflow.start\_run(run\_name="my\_run"):

§ lr = ElasticNet(alpha=alpha, l1\_ratio=l1\_ratio, random\_state=42)

§ lr.fit(train\_x, train\_y)

## Other topics[¶](https://doc.dataiku.com/dss/latest/mlops/experiment-tracking/tracking.html#other-topics "Permalink to this headline")

### Logging into another project[¶](https://doc.dataiku.com/dss/latest/mlops/experiment-tracking/tracking.html#logging-into-another-project "Permalink to this headline")

You can log experiments into another project than the current one by using:

§ project = dataiku.api\_client().get\_project("MYOTHERPROJECT")

### Experiment tracking outside DSS[¶](https://doc.dataiku.com/dss/latest/mlops/experiment-tracking/tracking.html#experiment-tracking-outside-dss "Permalink to this headline")

MLflow Tracking integration is configured through the `dataikuapi` package. See Using the APIs outside of DSS for how to use it from outside of DSS

### Usage without context manager[¶](https://doc.dataiku.com/dss/latest/mlops/experiment-tracking/tracking.html#usage-without-context-manager "Permalink to this headline")

While the usage of the context manager (“with” statement) is recommended, it is not mandatory. You can use this instead:

§ import dataiku

§ import mlflow

§ project = dataiku.api\_client().get\_default\_project()

§ managed\_folder = project.get\_managed\_folder('A\_MANAGED\_FOLDER\_ID')

§ mlflow\_handle = project.setup\_mlflow(managed\_folder=managed\_folder)

§ mlflow.set\_experiment("My first experiment")

§ with mlflow.start\_run(run\_name="my\_run"):

§ # ...your MLflow code...

§ mlflow.log\_param("a", 1)

§ mlflow.log\_metric("b", 2)

§ mlflow\_handle.clear()

### Cautions[¶](https://doc.dataiku.com/dss/latest/mlops/experiment-tracking/tracking.html#cautions "Permalink to this headline")

If you do not set up the integration before using the MLflow client, or use the client after clearing the integration, it may fall back to its default mode: writing experiment data as the current user, on the filesystem of the host of the DSS server.

### Supported versions[¶](https://doc.dataiku.com/dss/latest/mlops/experiment-tracking/tracking.html#supported-versions "Permalink to this headline")

See Limitations and supported versions for supported MLflow versions.
