# Component: Recipes[¶](https://doc.dataiku.com/dss/latest/plugins/reference/recipes.html#component-recipes "Permalink to this headline")

For more information about code recipes, see Recipes based on code.

To start creating a recipe plugin, you have to write a “regular” Python recipe and then make it reusable:

* Go to the Advanced tab

* Click on “Convert to custom recipe”

* Select the dev plugin to add the custom recipe to

* Click on “Convert”

## Recipe roles[¶](https://doc.dataiku.com/dss/latest/plugins/reference/recipes.html#recipe-roles "Permalink to this headline")

Each role has the following structure:

* `name`: Name of the role; this is how the role is referenced elsewhere in code

* `label`: A displayed name for this role

* `description`: A description of what the role means

* `arity`: UNARY or NARY (can accept one or multiple values?)

* `required` (boolean, default false): Does this role need to be filled?

* `acceptsDataset` (boolean, default true): Whether a dataset can be used for this role

* `acceptsManagedFolder` (boolean, default false): Whether a managed folder can be used for this role

* `acceptsSavedModel` (boolean, default false): Whether a saved model can be used for this role

## Advanced options for custom recipes[¶](https://doc.dataiku.com/dss/latest/plugins/reference/recipes.html#advanced-options-for-custom-recipes "Permalink to this headline")

### Select from flow view[¶](https://doc.dataiku.com/dss/latest/plugins/reference/recipes.html#select-from-flow-view "Permalink to this headline")

To make a new recipe directly available from the Flow view when selecting a dataset:

* Edit the `recipe.json` file

* Add the line `"selectableFromDataset": "main",`, where `main` must be replaced by the name of the input role in which the selected dataset will go

The resulting file will look like:

§ {

§ "meta" : {

§ "label" : "My custom recipe",

§ "icon" : "icon-puzzle-piece"

§ },

§ "kind" : "PYTHON",

§ "selectableFromDataset": "main",

§ "inputRoles" : [

§ {

§ "name": "main",

§ "label": "Input dataset",

§ "arity": "UNARY",

§ "required": true,

§ "acceptsDataset": true

§ }

§ ],

§ "outputRoles" : [

§ {

§ "name": "output",

§ "label": "Output dataset",

§ "arity": "UNARY",

§ "required": true,

§ "acceptsDataset": true

§ }

§ ],

§ "params": [],

§ "resourceKeys" : []

§ }

In a similar way, to make a new recipe directly available from the Flow view when selecting a managed folder:

* Edit the `recipe.json` file

* Add the line `"selectableFromFolder": "main",`, where `main` must be replaced by the name of the input role in which the selected managed folder will go

The resulting file will look like:

§ {

§ "meta" : {

§ "label" : "My custom recipe",

§ "icon" : "icon-puzzle-piece"

§ },

§ "kind" : "PYTHON",

§ "selectableFromFolder": "main",

§ "inputRoles" : [

§ {

§ "name": "main",

§ "label": "Input managed folder",

§ "arity": "UNARY",

§ "required": true,

§ "acceptsDataset": false,

§ "acceptsManagedFolder": true

§ }

§ ],

§ "outputRoles" : [

§ {

§ "name": "output",

§ "label": "Output dataset",

§ "arity": "UNARY",

§ "required": true,

§ "acceptsDataset": true

§ }

§ ],

§ "params": [],

§ "resourceKeys" : []

§ }

To make a new recipe directly available from the Flow view when selecting a saved model:

* Edit the `recipe.json` file

* Add the line `"selectableFromSavedModel": "main",`, where `main` must be replaced by the name of the input role in which the selected saved model will go

The resulting file will look like:

§ {

§ "meta" : {

§ "label" : "My custom recipe",

§ "icon" : "icon-puzzle-piece"

§ },

§ "kind" : "PYTHON",

§ "selectableFromSavedModel": "main",

§ "inputRoles" : [

§ {

§ "name": "main",

§ "label": "Input saved model",

§ "arity": "UNARY",

§ "required": true,

§ "acceptsDataset": false,

§ "acceptsSavedModel": true

§ }

§ ],

§ "outputRoles" : [

§ {

§ "name": "output",

§ "label": "Output dataset",

§ "arity": "UNARY",

§ "required": true,

§ "acceptsDataset": true

§ }

§ ],

§ "params": [],

§ "resourceKeys" : []

§ }

### Change icon color[¶](https://doc.dataiku.com/dss/latest/plugins/reference/recipes.html#change-icon-color "Permalink to this headline")

When you use lots of custom recipes in your flows, you may want to differentiate them by color. It allows for clearer flow views and easier distinction between different custom recipe operations.

DSS currently supports the following colors: red, pink, purple, blue, green, sky, yellow, orange, brown, grey.

You can specify the “iconColor” in the “meta” field of your `recipe.json` file:

§ {

§ "meta" : {

§ "label": "My custom recipe",

§ "icon": "icon-puzzle-piece",

§ "iconColor": "sky"

§ }

§ }
