# Geographic processors[¶](https://doc.dataiku.com/dss/latest/preparation/geographic.html#geographic-processors "Permalink to this headline")

The prepare recipe provides a variety of processors to work with geographic information.

For an overview of all geographic capabilities in DSS, please see Geographic data

DSS also provides a set of formulas to compute geographic operations (see Formula language)

* Geopoint converters

* Resolve GeoIP

* Reverse geocoding

* Zipcode geocoding

* Change coordinates system

* Compute distances between points

* Create area around a geopoint

* Extract from geo column

## Geopoint converters[¶](https://doc.dataiku.com/dss/latest/preparation/geographic.html#geopoint-converters "Permalink to this headline")

DSS provides two processors to convert between a Geopoint column and latitude/longitude columns:

* Create GeoPoint from lat/lon

* Extract lat/lon from GeoPoint

## Resolve GeoIP[¶](https://doc.dataiku.com/dss/latest/preparation/geographic.html#resolve-geoip "Permalink to this headline")

The Resolve GeoIP processor uses the GeoIP database (https://www.maxmind.com) to resolve an IP address to the associated geographic coordinates.

It produces two kinds of information:

* Administrative data (country, region, city, …)

* Geographic data (latitude, longitude)

The output GeoPoint can be used for Map Charts.

## Reverse geocoding[¶](https://doc.dataiku.com/dss/latest/preparation/geographic.html#reverse-geocoding "Permalink to this headline")

Please see Geocoding and reverse geocoding

## Zipcode geocoding[¶](https://doc.dataiku.com/dss/latest/preparation/geographic.html#zipcode-geocoding "Permalink to this headline")

Please see Geocoding and reverse geocoding

## Change coordinates system[¶](https://doc.dataiku.com/dss/latest/preparation/geographic.html#change-coordinates-system "Permalink to this headline")

This processor changes the Coordinates Reference System (CRS) of a geometry or geopoint column.

Source and target CRS can be given either as a EPSG code (e.g., “EPSG:4326”) or as a projected coordinate system WKT (e.g., “PROJCS[…]”).

Use this processor to convert data projected in a different CRS to the WGS84 (EPSG:4326) coordinates system.

## Compute distances between points[¶](https://doc.dataiku.com/dss/latest/preparation/geographic.html#compute-distances-between-points "Permalink to this headline")

The /preparation/processors/geopoint-distance processor allows you to compute distance between points

## Create area around a geopoint[¶](https://doc.dataiku.com/dss/latest/preparation/geographic.html#create-area-around-a-geopoint "Permalink to this headline")

The Create area around a geopoint processor performs creation of polygons centered on input geopoints. For each input geospatial point, a spatial polygon is created around it, delimiting the area of influence covered by the point (all the points that fall within a given distance from the geopoint). The shape area of the polygon can be either rectangular or circular (using an approximation) and the size will depend on the selected parameters.

## Extract from geo column[¶](https://doc.dataiku.com/dss/latest/preparation/geographic.html#extract-from-geo-column "Permalink to this headline")

The Extract from geo column processor extracts data from a geometry column:

* centroid point,

* length (if input is not a point),

* area (if input is a polygon).
