# Parse to standard date format[¶](https://doc.dataiku.com/dss/latest/preparation/processors/date-parser.html#parse-to-standard-date-format "Permalink to this headline")

Parse strings containing dates in any format into the standard ISO 8601 format (`yyyy-MM-ddTHH:mm:ss.SSSZ`) to work with them in DSS. Use Smart Dates to get semi-automatic date parsing with the assistance of DSS.

## Options[¶](https://doc.dataiku.com/dss/latest/preparation/processors/date-parser.html#options "Permalink to this headline")

**Column**

Apply date parsing to the following:

* A single column

* An explicit list of columns

* All columns matching a regex pattern

* All columns

**Output column**

Leave blank to parse data in-place or create a separate output column.

**Input date format(s)**

Open **Find with Smart Date** to get semi-automatic date parsing with the help of DSS. Otherwise, specify the format of your inputs column(s) using the Java syntax for date specifiers.

Note

Common patterns include y (year), M (month in year), w (week in year), d (day in month), E (day name in week), a (am/pm marker), H (hour in day 0-24), h (hour in am/pm 1-12), m (minute in hour), s (second in minute), S (millisecond), Z (time zone).

**Locale**

Translate date information in locale format (like ‘mercredi’ or ‘janvier’ in French).

**Timezone**

Provide details on the time zone, if needed. Options include using a TZ column, an IP column, or specifying a timezone from the dropdown. UTC is the default.

## Related resources[¶](https://doc.dataiku.com/dss/latest/preparation/processors/date-parser.html#related-resources "Permalink to this headline")

For more information on managing dates with Dataiku DSS, please see the reference documentation. If you prefer a hands-on approach, check out this brief tutorial on parsing dates with DSS.
