# Split HTTP Query String[¶](https://doc.dataiku.com/dss/latest/preparation/processors/querystring-split.html#split-http-query-string "Permalink to this headline")

This processor splits the elements of an HTTP query string.

The query string is the part coming after the `?` in the string. For example: `product\_id=234&step=3`

## Output[¶](https://doc.dataiku.com/dss/latest/preparation/processors/querystring-split.html#output "Permalink to this headline")

This processor outputs one column for each chunk of the query string. Columns are named with the prefix and the key of the HTTP Query string chunk.

## Example[¶](https://doc.dataiku.com/dss/latest/preparation/processors/querystring-split.html#example "Permalink to this headline")

For input:

| qs |

| --- |

| productid=234&step=3 |

| customer\_id=FDZ&action=cart&step=2 |

With prefix : ‘qs\_’, result would be:

| qs | qs\_product\_id | qs\_step | qs\_customer\_id | qs\_action |

| --- | --- | --- | --- | --- |

| productid=234&step=3 | 234 | 3 |  |  |

| customer\_id=FDZ&action=cart&step=2 |  | 2 | FDZ | cart |
