# Fleet Manager Tenant[¶](https://doc.dataiku.com/dss/latest/python-api/fleetmanager/tenant.html#fleet-manager-tenant "Permalink to this headline")

The FMCloudAuthentication and FMCloudCredentials help define how the authentication will be done on the cloud side.

FMCloudTags are the Fleet Manager tags.

## Reference API doc[¶](https://doc.dataiku.com/dss/latest/python-api/fleetmanager/tenant.html#reference-api-doc "Permalink to this headline")

*class* `dataikuapi.fm.tenant.``FMCloudAuthentication`(*data*)

*static* `aws_same_as_fm`()

AWS Only: use the same authentication as Fleet Manager

*static* `aws_iam_role`(*role\_arn*)

AWS Only: use an IAM Role

* Parameters: **role\_arn** (*str*) – ARN of the IAM Role

*static* `aws_keypair`(*access\_key\_id*, *secret\_access\_key*)

AWS Only: use an AWS Access Key

* Parameters: * **access\_key\_id** (*str*) – AWS Access Key ID
* **secret\_access\_key** (*str*) – AWS Secret Access Key

*static* `azure`(*subscription*, *tenant\_id*, *environment*, *client\_id*)

Azure Only

* Parameters: * **subscription** (*str*) – Azure Subscription
* **tenant\_id** (*str*) – Azure Tenant Id
* **environment** (*str*) – Azure Environment
* **client\_id** (*str*) – Azure Client Id

*static* `gcp`(*project\_id*, *service\_account\_key*)

GCP Only

* Parameters: * **project\_id** (*str*) – GCP project
* **service\_account\_key** (*str*) – Optional, service account key (JSON)

*class* `dataikuapi.fm.tenant.``FMCloudCredentials`(*client*, *cloud\_credentials*)

A Tenant Cloud Credentials in the FM instance

`set_cmk_key`(*cmk\_key\_id*)

`set_static_license`(*license\_file\_path=None*, *license\_string=None*)

Set a default static license for the DSS instances

* Parameters: * **license\_file\_path** (*str*) – Optional, load the license from a json file
* **license\_string** (*str*) – Optional, load the license from a json string

`set_automatically_updated_license`(*license\_token*)

Set an automatically updated license for the DSS instances

* Parameters: **license\_token** (*str*) – License token

`set_authentication`(*authentication*)

Set the authentication for the tenant

* Parameters: **authentication** (`dataikuapi.fm.tenant.FMCloudAuthentication`) – the authentication to be used

`save`()

Saves back the settings to the project

*class* `dataikuapi.fm.tenant.``FMCloudTags`(*client*, *cloud\_tags*)

A Tenant Cloud Tags in the FM instance

*property* `tags`

`save`()

Saves the tags on FM
