# The main GovernClient class[¶](https://doc.dataiku.com/dss/latest/python-api/govern/govern-client.html#the-main-governclient-class "Permalink to this headline")

The REST API Python client makes it easy to write client programs for the Dataiku Govern REST API in Python. The REST API Python client is in the `dataikuapi` Python package.

The client is the entrypoint for many of the capabilities listed in this chapter.

## Creating a Govern client[¶](https://doc.dataiku.com/dss/latest/python-api/govern/govern-client.html#creating-a-govern-client "Permalink to this headline")

To work with the API, a connection needs to be established with Dataiku Govern, by creating an `GovernClient` object. Once the connection is established, the `GovernClient` object serves as the entry point to the other calls.

To use the Python client from outside Dataiku Govern, simply install it from pip.

§ pip install dataiku-api-client

This installs the client in the system-wide Python installation, so if you are not using virtualenv, you may need to replace `pip` by `sudo pip`.

Note that this will always install the latest version of the API client. You might need to request a version compatible with your version of Dataiku Govern.

When connecting from the outside world, you need an API key. See Public API Keys for more information on how to create an API key and the associated privileges.

You also need to connect using the base URL of your Dataiku Govern instance.

§ import dataikuapi

§ host = "http(s)://DSS\_HOST:DSS\_PORT"

§ apiKey = "Your API key secret"

§ client = dataikuapi.GovernClient(host, apiKey)

§ # client is now a GovernClient and can perform all authorized actions.

§ # For example, list the blueprints for which the API key has access

§ client.list\_blueprints()

### Disabling SSL certificate check[¶](https://doc.dataiku.com/dss/latest/python-api/govern/govern-client.html#disabling-ssl-certificate-check "Permalink to this headline")

If your Dataiku Govern has SSL enabled, the package will verify the certificate. In order for this to work, you may need to add the root authority that signed the Govern SSL certificate to your local trust store. Please refer to your OS or Python manual for instructions.

If this is not possible, you can also disable checking the SSL certificate by setting `client.\_session.verify = False`

## Reference API doc[¶](https://doc.dataiku.com/dss/latest/python-api/govern/govern-client.html#reference-api-doc "Permalink to this headline")

*class* `dataikuapi.govern_client.``GovernClient`(*host*, *api\_key=None*, *internal\_ticket=None*, *extra\_headers=None*)

Entry point for the Govern API client

`get_blueprint_designer`()

Return a handle to interact with the blueprint designer Note: this call requires an API key with admin rights

* Return type: A `GovernAdminBlueprintDesigner`

`get_roles_permissions_handler`()

Return a handler to manage the roles and permissions of the Govern instance Note: this call requires an API key with admin rights

* Return type: A `GovernAdminRolesPermissionsHandler`

`get_custom_pages_handler`()

Return a handler to manage custom pages Note: this call requires an API key with admin rights

* Return type: A `GovernAdminCustomPagesHandler`

`list_blueprints`()

List all the blueprints

* Returns: a list of blueprints

* Return type: list of `GovernBlueprintListItem`

`get_blueprint`(*blueprint\_id*)

Get a handle to interact with a blueprint. If you want to edit it or one of its versions, use instead: `get\_blueprint()`

* Parameters: **blueprint\_id** (*str*) – id of the blueprint to retrieve

* Returns: The handle of the blueprint

* Return type: `GovernBlueprint`

`get_artifact`(*artifact\_id*)

Return a handle to interact with an artifact.

* Parameters: **artifact\_id** (*str*) – id of the artifact to retrieve

* Returns: the corresponding `GovernArtifact`

`create_artifact`(*artifact*)

Create an artifact

* Parameters: **artifact** (*dict*) – the definition of the artifact as a dict

* Returns: the created `GovernArtifact`

`new_artifact_search_request`(*artifact\_search\_query*)

Create a new artifact search request and return the object that will be used to launch the requests.

* Parameters: **artifact\_search\_query** (`GovernArtifactSearchQuery`) – The query that will be addressed during the search.

* Returns: The created artifact search request object

* Return type: `GovernArtifactSearchRequest`

`get_custom_page`(*custom\_page\_id*)

Retrieve a custom page. To edit a custom page use instead the custom page editor `get\_custom\_page()`

* Parameters: **custom\_page\_id** (*str*) – id of the custom page to retrieve

* Returns: the corresponding custom page object

* Return type: a `GovernCustomPage`

`list_custom_pages`()

List custom pages.

* Returns: a list of custom pages

* Return type: list of `GovernCustomPageListItem`

`get_time_series`(*time\_series\_id*)

Return a handle to interact with the time series

* Parameters: **time\_series\_id** (*str*) – ID of the time series

* Returns: the corresponding time series object

* Return type: a `GovernTimeSeries`

`get_uploaded_file`(*uploaded\_file\_id*)

Return a handle to interact with an uploaded file

* Parameters: **uploaded\_file\_id** (*str*) – ID of the uploaded file

* Returns: the corresponding uploaded file object

* Return type: a `GovernUploadedFile`

`upload_file`(*file\_name*, *file*)

Upload a file on Govern. Return a handle to interact with this new uploaded file.

* Parameters: * **file\_name** (*str*) – Name of the file
* **file** (*stream*) – file contents, as a stream - file-like object

* Returns: the newly uploaded file object

* Return type: a `GovernUploadedFile`

`list_users`(*as\_objects=False*)

List all user setup on the Govern instance Note: this call requires an API key with admin rights

* Returns: A list of users, as a list of `GovernUser` if as\_objects is True, else as a list of dicts

* Return type: list of `GovernUser` or list of dicts

`get_user`(*login*)

Get a handle to interact with a specific user

* Parameters: **login** (*str*) – the login of the desired user

* Returns: A `GovernUser` user handle

`get_own_user`()

Get a handle to interact with the current user

* Returns: A `GovernOwnUser` user handle

`create_user`(*login*, *password*, *display\_name=''*, *source\_type='LOCAL'*, *groups=None*, *profile='DATA\_SCIENTIST'*)

Create a user, and return a handle to interact with it

Note: this call requires an API key with admin rights

* Parameters: * **login** (*str*) – the login of the new user
* **password** (*str*) – the password of the new user
* **display\_name** (*str*) – the displayed name for the new user
* **source\_type** (*str*) – the type of new user. Admissible values are ‘LOCAL’ or ‘LDAP’
* **groups** (*list*) – the names of the groups the new user belongs to (defaults to [])
* **profile** (*str*) – The profile for the new user, can be one of READER, DATA\_ANALYST or DATA\_SCIENTIST

* Returns: A `GovernUser` user handle

`list_groups`()

List all groups setup on the Govern instance

Note: this call requires an API key with admin rights

* Returns: A list of groups, as a list of dicts

* Return type: list of dicts

`get_group`(*name*)

Get a handle to interact with a specific group

* Parameters: **name** (*str*) – the name of the desired group

* Returns: A `GovernGroup` group handle

`create_group`(*name*, *description=None*, *source\_type='LOCAL'*)

Create a group, and return a handle to interact with it

Note: this call requires an API key with admin rights

* Parameters: * **name** (*str*) – the name of the new group
* **description** (*str*) – (optional) a description of the new group
* **source\_type** (*str*) – the type of the new group. Admissible values are ‘LOCAL’ and ‘LDAP’

* Returns: A `GovernGroup` group handle

`list_global_api_keys`()

List all global API keys set up on the Govern instance

Note: this call requires an API key with admin rights

* Returns: All global API keys, as a list of dicts

`get_global_api_key`(*key*)

Get a handle to interact with a specific Global API key

* Parameters: **key** (*str*) – the secret key of the desired API key

* Returns: A `GovernGlobalApiKey` API key handle

`create_global_api_key`(*label=None*, *description=None*, *admin=False*)

Create a Global API key, and return a handle to interact with it

Note: this call requires an API key with admin rights

* Parameters: * **label** (*str*) – the label of the new API key
* **description** (*str*) – the description of the new API key
* **admin** (*boolean*) – has the new API key admin rights (True or False)

* Returns: A `GovernGlobalApiKey` API key handle

`list_logs`()

List all available log files on the Govern instance This call requires an API key with admin rights

* Returns: A list of log file names

`get_log`(*name*)

Get the contents of a specific log file This call requires an API key with admin rights

* Parameters: **name** (*str*) – the name of the desired log file (obtained with `list\_logs()`)

* Returns: The full content of the log file, as a string

`log_custom_audit`(*custom\_type*, *custom\_params=None*)

Log a custom entry to the audit trail

* Parameters: * **custom\_type** (*str*) – value for customMsgType in audit trail item
* **custom\_params** (*dict*) – value for customMsgParams in audit trail item (defaults to {})

`get_general_settings`()

Gets a handle to interact with the general settings.

This call requires an API key with admin rights

* Returns: a `GovernGeneralSettings` handle

`get_auth_info`()

Returns various information about the user currently authenticated using this instance of the API client.

This method returns a dict that may contain the following keys (may also contain others):

* authIdentifier: login for a user, id for an API key

* groups: list of group names (if context is a user)

* Returns: a dict

* Return type: dict

`get_licensing_status`()

Returns a dictionary with information about licensing status of this Govern instance

* Return type: dict

`set_license`(*license*)

Sets a new licence for Govern

* Parameters: **license** (*str*) – license (content of license file)

* Returns: None
