# Govern Artifact Search[¶](https://doc.dataiku.com/dss/latest/python-api/govern/govern-artifact-search.html#govern-artifact-search "Permalink to this headline")

The artifact search handler is used to search among artifacts.

## Search for all the Govern Project artifacts[¶](https://doc.dataiku.com/dss/latest/python-api/govern/govern-artifact-search.html#search-for-all-the-govern-project-artifacts "Permalink to this headline")

§ import dataikuapi

§ from dataikuapi.govern.artifact\_search import GovernArtifactSearchQuery, GovernArtifactFilterBlueprints

§ host = "http(s)://DSS\_HOST:DSS\_PORT"

§ apiKey = "Your API key secret"

§ client = dataikuapi.GovernClient(host, apiKey)

§ # build a query

§ govern\_projects\_query = GovernArtifactSearchQuery(artifact\_filters=[GovernArtifactFilterBlueprints(blueprint\_ids=['bp.system.govern\_project'])])

§ # build a request

§ request = client.new\_artifact\_search\_request(govern\_projects\_query)

§ # perform the search (first batch)

§ result\_1 = request.fetch\_next\_batch()

§ # continue the search (next batch)...

§ result\_2 = request.fetch\_next\_batch()

## Reference API doc[¶](https://doc.dataiku.com/dss/latest/python-api/govern/govern-artifact-search.html#reference-api-doc "Permalink to this headline")

*class* `dataikuapi.govern.artifact_search.``GovernArtifactSearchRequest`(*client*, *artifact\_search\_query*)

A search request object. Do not create this directly, use `new\_artifact\_search\_request()` and then run the query using `fetch\_next\_batch()`

`fetch_next_batch`(*page\_size=20*)

Run the search request fetching the next batch of results. Use page\_size to specify the size of the result page.

* Parameters: **page\_size** (*int*) – (Optional) size of the result page, default value is set to 20.

* Returns: The response of a single fetch of the search request

* Return type: a `GovernArtifactSearchResponse`

*class* `dataikuapi.govern.artifact_search.``GovernArtifactSearchResponse`(*client*, *response*)

A search request response for a single batch. Do not create this directly, use `fetch\_next\_batch()`.

`get_raw`()

Get the raw content of the search response

* Returns: the raw content of the search response as a dict

* Return type: dict

`get_response_hits`()

Get the search response hits (artifacts)

* Returns: list of the search response hits (artifacts)

* Return type: list of `GovernArtifactSearchResponseHit`

*class* `dataikuapi.govern.artifact_search.``GovernArtifactSearchResponseHit`(*client*, *hit*)

A search request response. Do not create this directly, use `get\_response\_hits()`.

`get_raw`()

Get the raw content of the search response hit

* Returns: the raw content of the search response hit as a dict

* Return type: dict

`to_artifact`()

Gets the `GovernArtifact` corresponding to this search response hit

* Returns: the custom page object

* Return type: a `GovernArtifact`

*class* `dataikuapi.govern.artifact_search.``GovernArtifactSearchQuery`(*artifact\_search\_source=None*, *artifact\_filters=None*, *artifact\_search\_sort=None*)

A definition of an artifact query. Instantiate and interact with this object to customize the query.

* Parameters: * **artifact\_search\_source** (`GovernArtifactSearchSource`) – (Optional) The search source to target a subset of artifacts.
For now, by default, the search will be executed on all artifacts using the
`GovernArtifactSearchSourceAll` search source.
* **artifact\_filters** (list of `GovernArtifactFilter`) – A list of filters to apply on the query.
* **artifact\_search\_sort** (`GovernArtifactSearchSort`) – The sort configuration to apply on the query

`set_artifact_search_source`(*artifact\_search\_source*)

Set a search source for this query

* Parameters: **artifact\_search\_source** (`GovernArtifactSearchSource`) – (Optional) The search source to target a subset of artifacts.
For now, by default, the search will be executed on all artifacts using the
`GovernArtifactSearchSourceAll` search source.

* Returns: None

`clear_artifact_filters`()

Remove the filters set for this query

* Returns: None

`add_artifact_filter`(*artifact\_filter*)

Add a new artifact filter to the filter list of the query.

* Parameters: **artifact\_filter** (`GovernArtifactFilter`) – A filter to add to the filter list.

* Returns: None

`clear_artifact_search_sort`()

Remove the sort configuration of this query.

* Returns: None

`set_artifact_search_sort`(*artifact\_search\_sort*)

Set a new search sort configuration for this request.

* Parameters: **artifact\_search\_sort** (`GovernArtifactSearchSort`) – The sort configuration to apply on the query

* Returns: None

`build`()

* Returns: the search query definition

* Return type: (dict, dict)

*class* `dataikuapi.govern.artifact_search.``GovernArtifactSearchSource`(*search\_source\_type*)

An abstract class to represent the different search source. Do not instantiate this class but one of its subclasses.

`build`()

*class* `dataikuapi.govern.artifact_search.``GovernArtifactSearchSourceAll`

A generic search source definition.

`build`()

* Returns: the search source definition as a dict

* Return type: dict

*class* `dataikuapi.govern.artifact_search.``GovernArtifactSearchSort`(*artifact\_search\_sort\_type*, *direction*)

An abstract class to represent the different search sort. Do not instantiate this class but one of its subclasses.

`build`()

*class* `dataikuapi.govern.artifact_search.``GovernArtifactSearchSortName`(*direction='ASC'*)

An artifact sort definition based on their names.

* Parameters: **direction** (*str*) – (Optional) The direction on which the artifacts will be sorted. Can be either “ASC” or “DESC”

`build`()

* Returns: the search sort definition as a dict

* Return type: dict

*class* `dataikuapi.govern.artifact_search.``GovernArtifactSearchSortWorkflow`(*direction='ASC'*)

An artifact sort defintion based on their workflow.

* Parameters: **direction** (*str*) – (Optional) The direction on which the artifacts will be sorted. Can be either “ASC” or “DESC”

`build`()

* Returns: the search sort definition as a dict

* Return type: dict

*class* `dataikuapi.govern.artifact_search.``GovernArtifactSearchSortField`(*fields=None*, *direction='ASC'*)

An artifact sort definition based on a list of fields.

* Parameters: * **fields** (*list of dict*) – (Optional) A list of fields on which the artifacts will be sorted.
Use `build()` to build a field based sort definition.
* **direction** (*str*) – (Optional) The direction on which the artifacts will be sorted. Can be either “ASC” or “DESC”

`build`()

* Returns: the search sort definition as a dict

* Return type: dict

*class* `dataikuapi.govern.artifact_search.``GovernArtifactSearchSortFieldDefinition`(*blueprint\_id*, *field\_id*)

A field sort definition builder to use in a search query in order to sort on a field of a blueprint.

* Parameters: * **blueprint\_id** (*str*) – the Blueprint ID
* **field\_id** (*str*) – the field ID

`build`()

* Returns: the field search sort definition

* Return type: dict

*class* `dataikuapi.govern.artifact_search.``GovernArtifactFilter`(*filter\_type*)

An abstract class to represent artifact filters. Do not instance this class but one of its subclasses.

`build`()

*class* `dataikuapi.govern.artifact_search.``GovernArtifactFilterBlueprints`(*blueprint\_ids=None*)

An artifact filter definition based on a list of specific blueprints.

* Parameters: * **blueprint\_ids** – (Optional) the list of blueprint IDs to use to filter the artifacts
* **blueprint\_ids** – lsit of str

`build`()

* Returns: the artifact filter definition as a dict

* Return type: dict

*class* `dataikuapi.govern.artifact_search.``GovernArtifactFilterBlueprintVersions`(*blueprint\_version\_ids=None*)

An artifact filter definition based on a list of specific blueprint versions.

* Parameters: **blueprint\_version\_ids** (*list of dict*) – (Optional) the list of blueprint version IDs to use to filter the artifacts.
Use `build()` to build a blueprint version ID definition.

`build`()

* Returns: the artifact filter definition as a dict

* Return type: dict

*class* `dataikuapi.govern.artifact_search.``GovernArtifactFilterArtifacts`(*artifact\_ids=None*)

An artifact filter definition based on a list of specific artifacts.

* Parameters: **artifact\_ids** (*list of str*) – (Optional) the list of artifacts IDs to use to filter the artifacts.

`build`()

* Returns: the artifact filter definition as a dict

* Return type: dict

*class* `dataikuapi.govern.artifact_search.``GovernArtifactFilterFieldValue`(*condition\_type*, *condition=None*, *field\_id=None*, *negate\_condition=None*, *case\_sensitive=None*)

An artifact filter definition based on specific fields value.

* Parameters: * **condition\_type** (*str*) – the condition type of the filter. Has to be chosen from EQUALS, CONTAINS, START\_WITH, END\_WITH.
* **condition** (*str*) – (Optional) The value on which the condition will be applied.
* **field\_id** (*str*) – (Optional) The ID of the field on which the condition will be applied. If not specified the filter will apply on the name.
* **negate\_condition** (*boolean*) – (Optional) A boolean to negate the condition. By default, the condition is not negated.
* **case\_sensitive** (*str*) – (Optional) Can be used to activate case-sensitive filtering. By default, filters will not be case-sensitive.

`build`()

* Returns: the artifact filter definition as a dict

* Return type: dict

*class* `dataikuapi.govern.artifact_search.``GovernArtifactFilterArchivedStatus`(*is\_archived*)

An artifact filter definition based on the archived status.

* Parameters: **is\_archived** (*boolean*) – the value for filtering. If is\_archived is set to True, all artifacts including archived ones will be part of the search result

`build`()

* Returns: the artifact filter definition as a dict

* Return type: dict
