# Other administration tasks[¶](https://doc.dataiku.com/dss/latest/python-api/govern/govern-other-administration.html#other-administration-tasks "Permalink to this headline")

Here are some more global administration tasks that can be performed using the DSS Public API:

* Reading and writing general instance settings

* Managing global API keys

## Reference documentation[¶](https://doc.dataiku.com/dss/latest/python-api/govern/govern-other-administration.html#reference-documentation "Permalink to this headline")

*class* `dataikuapi.govern.admin.``GovernGeneralSettings`(*client*)

The general settings of the Govern instance. Do not create this object directly, use `get\_general\_settings()` instead.

`save`()

Save the changes that were made to the settings on the Govern instance Note: this call requires an API key with admin rights

`get_raw`()

Get the settings as a dictionary

*class* `dataikuapi.govern.admin.``GovernGlobalApiKey`(*client*, *key*)

A global API key on the Govern instance

`delete`()

Delete the api key

Note: this call requires an API key with admin rights

`get_definition`()

Get the API key’s definition

Note: this call requires an API key with admin rights

* Returns: a dict - the definition of the API key

* Return type: dict

`set_definition`(*definition*)

Set the API key’s definition.

Note: this call requires an API key with admin rights

* Param: dict definition: the definition for the API key, as a dict

* Returns: a dict - the definition of the API key

* Return type: dict
