# Govern Time series[¶](https://doc.dataiku.com/dss/latest/python-api/govern/govern-time-series.html#govern-time-series "Permalink to this headline")

Time series data can be stored in artifacts.

## Retrieve time series data[¶](https://doc.dataiku.com/dss/latest/python-api/govern/govern-time-series.html#retrieve-time-series-data "Permalink to this headline")

§ import dataikuapi

§ host = "http(s)://DSS\_HOST:DSS\_PORT"

§ apiKey = "Your API key secret"

§ client = dataikuapi.GovernClient(host, apiKey)

§ # retrieve a specific artifact of type dataiku model version by its ID

§ artifact = client.get\_artifact('ar.1773')

§ # get the time series ID from a field

§ ts = client.get\_time\_series(artifact.get\_definition().get\_raw()['fields']['evaluation\_metrics\_auc'])

§ # get the time series values

§ values = ts.get\_values()

## Reference API doc[¶](https://doc.dataiku.com/dss/latest/python-api/govern/govern-time-series.html#reference-api-doc "Permalink to this headline")

*class* `dataikuapi.govern.time_series.``GovernTimeSeries`(*client*, *time\_series\_id*)

A handle to interact with a time series. Do not create this directly, use `get\_time\_series()`

`get_values`(*min\_timestamp=None*, *max\_timestamp=None*)

Get the values of the time series. Use the parameters min\_timestamp and max\_timestamp to define a time window. Only values within this window will be returned

* Parameters: * **min\_timestamp** (*int*) – (Optional) The minimum timestamp of the time window as an epoch in milliseconds
* **max\_timestamp** (*int*) – (Optional) The maximum timestamp of the time window as an epoch in milliseconds

* Returns: a list data points of the time series as Python dict

* Return type: list of dict

`push_values`(*datapoints*, *upsert=True*)

Push a list of values inside the time series.

* Parameters: * **datapoints** (*list*) – a list of Python dict - The list of datapoints as Python dict containing the following keys “timeSeriesId”, “timestamp” (an epoch in milliseconds), and “value” (an object)
* **upsert** (*boolean*) – (Optional) If set to false, values for existing timestamps will not be overridden. Default value is True.

* Returns: None

`delete`(*min\_timestamp=None*, *max\_timestamp=None*)

Delete the values of the time series. Use the parameters min\_timestamp and max\_timestamp to define a time window. Only values within this window will be deleted.

* Parameters: * **min\_timestamp** (*int*) – (Optional) The minimum timestamp of the time window as an epoch in milliseconds
* **max\_timestamp** (*int*) – (Optional) The maximum timestamp of the time window as an epoch in milliseconds

* Returns: None
