# Govern Uploaded Files[¶](https://doc.dataiku.com/dss/latest/python-api/govern/govern-uploaded-files.html#govern-uploaded-files "Permalink to this headline")

Users can upload files to artifacts.

## Download an uploaded file[¶](https://doc.dataiku.com/dss/latest/python-api/govern/govern-uploaded-files.html#download-an-uploaded-file "Permalink to this headline")

§ import dataikuapi

§ host = "http(s)://DSS\_HOST:DSS\_PORT"

§ apiKey = "Your API key secret"

§ client = dataikuapi.GovernClient(host, apiKey)

§ # retrieve a specific artifact of type govern project by its ID

§ artifact = client.get\_artifact('ar.1773')

§ # get the first uploaded file stored in the related\_docs field

§ uf = client.get\_uploaded\_file(artifact.get\_definition().get\_raw()['fields']['related\_docs'][0])

§ # get the file description

§ f\_desc = uf.get\_description()

§ # retrieve the file as a stream

§ f\_stream = uf.download()

## Reference API doc[¶](https://doc.dataiku.com/dss/latest/python-api/govern/govern-uploaded-files.html#reference-api-doc "Permalink to this headline")

*class* `dataikuapi.govern.uploaded_file.``GovernUploadedFile`(*client*, *uploaded\_file\_id*)

A handle to interact with an uploaded file Do not create this directly, use `get\_uploaded\_file()`

`get_description`()

Get the description of the uploaded file.

* Returns: The description of the file as a python dict

* Return type: dict

`download`()

Download the uploaded file

* Returns: the uploaded file contents, as a stream - file-like object

* Return type: a stream - file-like object

`delete`()

Delete the file

* Returns: None
