# Project Deployer[¶](https://doc.dataiku.com/dss/latest/python-api/project-deployer.html#project-deployer "Permalink to this headline")

## Reference documentation[¶](https://doc.dataiku.com/dss/latest/python-api/project-deployer.html#reference-documentation "Permalink to this headline")

### Project Deployer[¶](https://doc.dataiku.com/dss/latest/python-api/project-deployer.html#id1 "Permalink to this headline")

*class* `dataikuapi.dss.projectdeployer.``DSSProjectDeployer`(*client*)

Handle to interact with the Project Deployer.

Do not create this directly, use `dataikuapi.dss.DSSClient.get\_projectdeployer()`

`list_deployments`(*as\_objects=True*)

Lists deployments on the Project Deployer

* Parameters: **as\_objects** (*boolean*) – if True, returns a list of `DSSProjectDeployerDeployment`, else returns a list of dict.
Each dict contains at least a field “id” indicating the identifier of this deployment

* Returns: a list - see as\_objects for more information

* Return type: list

`get_deployment`(*deployment\_id*)

Returns a handle to interact with a single deployment, as a `DSSProjectDeployerDeployment`

* Parameters: **deployment\_id** (*str*) – Identifier of the deployment to get

* Return type: `DSSProjectDeployerDeployment`

`create_deployment`(*deployment\_id*, *project\_key*, *infra\_id*, *bundle\_id*, *deployed\_project\_key=None*, *project\_folder\_id=None*, *ignore\_warnings=False*)

Creates a deployment and returns the handle to interact with it. The returned deployment is not yet started and you need to call `start\_update()`

* Parameters: * **deployment\_id** (*str*) – Identifier of the deployment to create
* **project\_key** (*str*) – The source published project key
* **infra\_id** (*str*) – Identifier of the deployment infrastructure to use
* **bundle\_id** (*str*) – Identifier of the bundle to deploy
* **deployed\_project\_key** (*str*) – The project key to use when deploying this project to the automation node. If
not set, the project will be created with the same project key as the source
published project
* **project\_folder\_id** (*str*) – The automation node project folder id to deploy this project into. If not set,
the project will be created in the root folder
* **ignore\_warnings** (*boolean*) – ignore warnings concerning the governance status of the bundle to deploy

* Return type: `DSSProjectDeployerDeployment`

`list_stages`()

Lists infrastructure stages of the Project Deployer

* Return type: list of dict. Each dict contains a field “id” for the stage identifier and “desc” for its description.

* Return type: list

`list_infras`(*as\_objects=True*)

Lists deployment infrastructures on the Project Deployer

* Parameters: **as\_objects** (*boolean*) – if True, returns a list of `DSSProjectDeployerInfra`, else returns a list of dict.
Each dict contains at least a field “id” indicating the identifier of this infra

* Returns: a list - see as\_objects for more information

* Return type: list

`create_infra`(*infra\_id*, *stage*, *govern\_check\_policy='NO\_CHECK'*)

Creates a new infrastructure on the Project Deployer and returns the handle to interact with it.

* Parameters: * **infra\_id** (*str*) – Unique Identifier of the infra to create
* **stage** (*str*) – Infrastructure stage
* **govern\_check\_policy** (*str*) – PREVENT, WARN, or NO\_CHECK depending if the deployer will check wether the bundle deployed on this infrastructure has to be managed and approved in Dataiku Govern

* Return type: `DSSProjectDeployerInfra`

`get_infra`(*infra\_id*)

Returns a handle to interact with a single deployment infra, as a `DSSProjectDeployerInfra`

* Parameters: **infra\_id** (*str*) – Identifier of the infra to get

* Return type: `DSSProjectDeployerInfra`

`list_projects`(*as\_objects=True*)

Lists published projects on the Project Deployer

* Parameters: **as\_objects** (*boolean*) – if True, returns a list of `DSSProjectDeployerProject`, else returns a list of dict.
Each dict contains at least a field “id” indicating the identifier of this project

* Returns: a list - see as\_objects for more information

* Return type: list

`create_project`(*project\_key*)

Creates a new project on the Project Deployer and returns the handle to interact with it.

* Parameters: **project\_key** (*str*) – Identifier of the project to create

* Return type: `DSSProjectDeployerProject`

`get_project`(*project\_key*)

Returns a handle to interact with a single project, as a `DSSProjectDeployerProject`

* Parameters: **project\_key** (*str*) – Identifier of the project to get

* Return type: `DSSProjectDeployerProject`

`upload_bundle`(*fp*, *project\_key=None*)

Uploads a new version for a project from a file-like object pointing to a bundle Zip file.

* Parameters: * **fp** (*string*) – A file-like object pointing to a bundle Zip file
* **project\_key** (*string*) – The key of the published project where the bundle will be uploaded. If the project does not exist, it is created.

If not set, the key of the bundle’s source project is used.

#### Infrastructures[¶](https://doc.dataiku.com/dss/latest/python-api/project-deployer.html#infrastructures "Permalink to this headline")

*class* `dataikuapi.dss.projectdeployer.``DSSProjectDeployerInfra`(*client*, *infra\_id*)

An Automation infrastructure on the Project Deployer

Do not create this directly, use `get\_infra()`

*property* `id`

`get_status`()

Returns status information about this infrastructure

* Return type: `dataikuapi.dss.projectdeployer.DSSProjectDeployerInfraStatus`

`get_settings`()

Gets the settings of this infra. If you want to modify the settings, you need to call `save()` on the returned object

* Returns: a `dataikuapi.dss.projectdeployer.DSSProjectDeployerInfraSettings`

`delete`()

Deletes this infra You may only delete an infra if it has no deployments on it anymore.

*class* `dataikuapi.dss.projectdeployer.``DSSProjectDeployerInfraSettings`(*client*, *infra\_id*, *settings*)

The settings of an Automation infrastructure.

Do not create this directly, use `get\_settings()`

`get_raw`()

Gets the raw settings of this infra. This returns a reference to the raw settings, not a copy, so changes made to the returned object will be reflected when saving.

* Return type: dict

`save`()

Saves back these settings to the infra

*class* `dataikuapi.dss.projectdeployer.``DSSProjectDeployerInfraStatus`(*client*, *infra\_id*, *light\_status*)

The status of an Automation infrastructure.

Do not create this directly, use `get\_status()`

`get_deployments`()

Returns the deployments that are deployed on this infrastructure

* Returns: a list of deployments

* Return type: list of `dataikuapi.dss.projectdeployer.DSSProjectDeployerDeployment`

`get_raw`()

Gets the raw status information. This returns a dictionary with various information about the infrastructure

* Return type: dict

#### Published projects[¶](https://doc.dataiku.com/dss/latest/python-api/project-deployer.html#published-projects "Permalink to this headline")

*class* `dataikuapi.dss.projectdeployer.``DSSProjectDeployerProject`(*client*, *project\_key*)

A project on the Project Deployer

Do not create this directly, use `get\_project()`

*property* `id`

`get_status`()

Returns status information about this project. This is used mostly to get information about which versions are available and which deployments are exposing this project

* Return type: dataikuapi.dss.projectdeployer.DSSProjectDeployerProjectStatus

`get_settings`()

Gets the settings of this project. If you want to modify the settings, you need to call `save()` on the returned object.

The main things that can be modified in a project settings are permissions

* Returns: a `dataikuapi.dss.projectdeployer.DSSProjectDeployerProjectSettings`

`delete_bundle`(*bundle\_id*)

Deletes a bundle from this project

* Parameters: **bundle\_id** (*string*) – The identifier of the bundle to delete

`delete`()

Deletes this project

You may only delete a project if it has no deployments on it anymore.

*class* `dataikuapi.dss.projectdeployer.``DSSProjectDeployerProjectSettings`(*client*, *project\_key*, *settings*)

The settings of a published project.

Do not create this directly, use `get\_settings()`

`get_raw`()

Gets the raw settings of this deployment. This returns a reference to the raw settings, not a copy, so changes made to the returned object will be reflected when saving.

* Return type: dict

`save`()

Saves back these settings to the project

*class* `dataikuapi.dss.projectdeployer.``DSSProjectDeployerProjectStatus`(*client*, *project\_key*, *light\_status*)

The status of a published project.

Do not create this directly, use `get\_status()`

`get_deployments`(*infra\_id=None*)

Returns the deployments that have been created from this published project

* Parameters: **infra\_id** (*str*) – Identifier of an infra, allows to only keep in the returned list the deployments on this infra.

If not set, the list contains all the deployments using this published project, across every infra of the Project Deployer.

* Returns: a list of deployments

* Return type: list of `dataikuapi.dss.projectdeployer.DSSProjectDeployerDeployment`

`get_bundles`()

Returns the bundles that have been published on this project

Each bundle is a dict that contains at least a “id” field, which is the version identifier

* Returns: a list of bundles, each as a dict containing a “id” field

* Return type: list of dicts

`get_raw`()

Gets the raw status information. This returns a dictionary with various information about the project

* Return type: dict

#### Deployments[¶](https://doc.dataiku.com/dss/latest/python-api/project-deployer.html#deployments "Permalink to this headline")

*class* `dataikuapi.dss.projectdeployer.``DSSProjectDeployerDeployment`(*client*, *deployment\_id*)

A Deployment on the Project Deployer

Do not create this directly, use `get\_deployment()`

*property* `id`

`get_status`()

Returns status information about this deployment

* Return type: dataikuapi.dss.apideployer.DSSProjectDeployerDeploymentStatus

`get_governance_status`(*bundle\_id=''*)

Returns the governance status about this deployment if applicable

* Parameters: **bundle\_id** (*str*) – (Optional) The ID of a specific bundle of the published project to get status from. If empty, consider the bundle currently used in the deployment.

* Return type: dict InforMessages containing the governance status

`get_settings`()

Gets the settings of this deployment. If you want to modify the settings, you need to call `save()` on the returned object

* Returns: a `dataikuapi.dss.projectdeployer.DSSProjectDeployerDeploymentSettings`

`start_update`()

Starts an asynchronous update of this deployment to try to match the actual state to the current settings

* Returns: a `dataikuapi.dss.future.DSSFuture` tracking the progress of the update. Call
`wait\_for\_result()` on the returned object
to wait for completion (or failure)

`delete`()

Deletes this deployment

You may only delete a deployment if it is disabled and has been updated after disabling it.

*class* `dataikuapi.dss.projectdeployer.``DSSProjectDeployerDeploymentSettings`(*client*, *deployment\_id*, *settings*)

The settings of a Project Deployer deployment.

Do not create this directly, use `get\_settings()`

`get_raw`()

Gets the raw settings of this deployment. This returns a reference to the raw settings, not a copy, so changes made to the returned object will be reflected when saving.

* Return type: dict

*property* `bundle_id`

Gets or sets the bundle id currently used by this deployment. When setting, you need to call `save()` afterward for the change to be effective.

`save`(*ignore\_warnings=False*)

Saves back these settings to the deployment

* Parameters: **ignore\_warnings** (*boolean*) – ignore warnings concerning the governance status of the bundle to deploy

*class* `dataikuapi.dss.projectdeployer.``DSSProjectDeployerDeploymentStatus`(*client*, *deployment\_id*, *light\_status*, *heavy\_status*)

The status of a Project Deployer deployment.

Do not create this directly, use `get\_status()`

`get_light`()

Gets the ‘light’ (summary) status. This returns a dictionary with various information about the deployment, but not the actual health of the deployment

* Return type: dict

`get_heavy`()

Gets the ‘heavy’ (full) status. This returns a dictionary with various information about the deployment

* Return type: dict

`get_health`()

Returns the health of this deployment as a string

* Returns: HEALTHY if the deployment is working properly, various other status otherwise

* Return type: string

`get_health_messages`()

Returns messages about the health of this deployment
