# Users and groups[¶](https://doc.dataiku.com/dss/latest/python-api/rest-api-client/users-groups.html#users-and-groups "Permalink to this headline")

The API exposes key parts of the DSS access control management: users and groups. All these can be created, modified and deleted through the API.

* Example use cases

+ Listing users

+ Creating a user

- A local user with a password

- A user who will login through LDAP

- A user who will login through SSO

+ Modifying a user’s display name, groups, profile, email, …

+ Deleting a user

+ Modifying user and admin properties

+ Modifying user secrets

+ Entering a per-user-credential for a connection

+ Entering a per-user-credential for a plugin preset

+ Impersonating another user

+ Modifying user secrets

+ Listing groups

+ Creating a group

+ Modifying settings of a group

+ Deleting a group

* Reference documentation

## Example use cases[¶](https://doc.dataiku.com/dss/latest/python-api/rest-api-client/users-groups.html#example-use-cases "Permalink to this headline")

In all examples, client is a `dataikuapi.DSSClient`, obtained either using `dataikuapi.DSSClient.\_\_init\_\_()` or `dataiku.api\_client()`

### Listing users[¶](https://doc.dataiku.com/dss/latest/python-api/rest-api-client/users-groups.html#listing-users "Permalink to this headline")

§ client = DSSClient(host, apiKey)

§ dss\_users = client.list\_users()

§ # dss\_users is a list of dict. Each item represents one user

§ prettyprinter.pprint(dss\_users)

outputs

§ [   {   'activeWebSocketSesssions': 0,

§ 'codeAllowed': True,

§ 'displayName': 'Administrator',

§ 'groups': ['administrators', 'data\_scientists'],

§ 'login': 'admin',

§ 'objectImgHash': 0,

§ 'sourceType': 'LOCAL'},

§ ...

§ ]

### Creating a user[¶](https://doc.dataiku.com/dss/latest/python-api/rest-api-client/users-groups.html#creating-a-user "Permalink to this headline")

#### A local user with a password[¶](https://doc.dataiku.com/dss/latest/python-api/rest-api-client/users-groups.html#a-local-user-with-a-password "Permalink to this headline")

§ new\_user = client.create\_user('test\_login', 'test\_password', display\_name='a test user', groups=['all\_powerful\_group'])

new\_user is a `dataikuapi.dss.admin.DSSUser`

#### A user who will login through LDAP[¶](https://doc.dataiku.com/dss/latest/python-api/rest-api-client/users-groups.html#a-user-who-will-login-through-ldap "Permalink to this headline")

Note that it is not usually required to manually create users who will login through LDAP as they can be automatically provisionned

§ new\_user = client.create\_user('test\_login', password=None, display\_name='a test user', source\_type="LDAP", groups=['all\_powerful\_group'], profile="DESIGNER")

#### A user who will login through SSO[¶](https://doc.dataiku.com/dss/latest/python-api/rest-api-client/users-groups.html#a-user-who-will-login-through-sso "Permalink to this headline")

This is only for non-LDAP users that thus will not be automatically provisioned, buut should still be able to log in through SSO.

§ new\_user = client.create\_user('test\_login', password=None, display\_name='a test user', source\_type="LOCAL\_NO\_AUTH", groups=['all\_powerful\_group'], profile="DESIGNER")

### Modifying a user’s display name, groups, profile, email, …[¶](https://doc.dataiku.com/dss/latest/python-api/rest-api-client/users-groups.html#modifying-a-user-s-display-name-groups-profile-email "Permalink to this headline")

To modify the settings of a user, get a handle through `dataikuapi.DSSClient.get\_user()`, then use `dataikuapi.dss.admin.DSSUser.get\_settings()`

§ user = client.get\_user("theuserslogin")

§ settings = user.get\_settings()

§ # Modify the settings in the `get\_raw()` dict

§ settings.get\_raw()["displayName"] = "DSS Lover"

§ settings.get\_raw()["email"] = "[email protected]"

§ settings.get\_raw()["userProfile"] = "DESIGNER"

§ settings.get\_raw()["groups"] = ["group1", "group2", "group3"] # This completely overrides previous groups

§ # Save the modifications

§ settings.save()

### Deleting a user[¶](https://doc.dataiku.com/dss/latest/python-api/rest-api-client/users-groups.html#deleting-a-user "Permalink to this headline")

§ user = client.get\_user('test\_login')

§ user.delete()

### Modifying user and admin properties[¶](https://doc.dataiku.com/dss/latest/python-api/rest-api-client/users-groups.html#modifying-user-and-admin-properties "Permalink to this headline")

§ user = client.get\_user("test\_login")

§ settings = user.get\_settings()

§ settings.user\_properties["myprop"] = "myvalue"

§ settings\_admin\_properties["myadminprop"] = "myadminvalue"

§ settings.save()

### Modifying user secrets[¶](https://doc.dataiku.com/dss/latest/python-api/rest-api-client/users-groups.html#modifying-user-secrets "Permalink to this headline")

§ user = client.get\_user("test\_login")

§ settings = user.get\_settings()

§ settings.add\_secret("secretname", "secretvalue")

§ settings.save()

### Entering a per-user-credential for a connection[¶](https://doc.dataiku.com/dss/latest/python-api/rest-api-client/users-groups.html#entering-a-per-user-credential-for-a-connection "Permalink to this headline")

§ user = client.get\_user('test\_login')

§ settings = user.get\_settings()

§ settings.set\_basic\_connection\_credential("myconnection", "username", "password")

§ settings.save()

### Entering a per-user-credential for a plugin preset[¶](https://doc.dataiku.com/dss/latest/python-api/rest-api-client/users-groups.html#entering-a-per-user-credential-for-a-plugin-preset "Permalink to this headline")

§ user = client.get\_user('test\_login')

§ settings = user.get\_settings()

§ settings.set\_basic\_plugin\_credential("myplugin", "my\_paramset\_id", "mypreset\_id", "param\_name", "username", "password")

§ settings.save()

### Impersonating another user[¶](https://doc.dataiku.com/dss/latest/python-api/rest-api-client/users-groups.html#impersonating-another-user "Permalink to this headline")

As a DSS administrator, it can be useful to be able to perform API calls on behalf of another user.

§ user = client.get\_user("the\_user\_to\_impersonate")

§ client\_as\_user = user.get\_client\_as()

§ # All calls done using `client\_as\_user` will appear as being performed by `the\_user\_to\_impersonate` and will inherit

§ # its permissions

### Modifying user secrets[¶](https://doc.dataiku.com/dss/latest/python-api/rest-api-client/users-groups.html#id1 "Permalink to this headline")

§ user = client.get\_user("an\_user")

§ settings = user.get\_settings()

§ settings.add\_secret("secretname", "secretvalue")

§ settings.save()

### Listing groups[¶](https://doc.dataiku.com/dss/latest/python-api/rest-api-client/users-groups.html#listing-groups "Permalink to this headline")

A list of the groups can by obtained with the list\_groups method:

§ client = DSSClient(host, apiKey)

§ # dss\_groups is a list of dict. Each group contains at least a "name" attribute

§ dss\_groups = client.list\_groups()

§ prettyprinter.pprint(dss\_groups)

outputs

§ [   {   'admin': True,

§ 'description': 'DSS administrators',

§ 'name': 'administrators',

§ 'sourceType': 'LOCAL'},

§ {   'admin': False,

§ 'description': 'Read-write access to projects',

§ 'name': 'data\_scientists',

§ 'sourceType': 'LOCAL'},

§ {   'admin': False,

§ 'description': 'Read-only access to projects',

§ 'name': 'readers',

§ 'sourceType': 'LOCAL'}]

### Creating a group[¶](https://doc.dataiku.com/dss/latest/python-api/rest-api-client/users-groups.html#creating-a-group "Permalink to this headline")

§ new\_group = client.create\_group('test\_group', description='test group', source\_type='LOCAL')

### Modifying settings of a group[¶](https://doc.dataiku.com/dss/latest/python-api/rest-api-client/users-groups.html#modifying-settings-of-a-group "Permalink to this headline")

First, retrieve the group definition with a get\_definition call, alter the definition, and set it back into DSS:

§ group\_definition = new\_group.get\_definition()

§ group\_definition['admin'] = True

§ group\_definition['ldapGroupNames'] = 'group1,group2'

§ new\_group.set\_definition(group\_definition)

### Deleting a group[¶](https://doc.dataiku.com/dss/latest/python-api/rest-api-client/users-groups.html#deleting-a-group "Permalink to this headline")

§ group = client.get\_group('test\_group')

§ group.delete()

## Reference documentation[¶](https://doc.dataiku.com/dss/latest/python-api/rest-api-client/users-groups.html#reference-documentation "Permalink to this headline")

*class* `dataikuapi.dss.admin.``DSSUser`(*client*, *login*)

A handle for a user on the DSS instance. Do not create this object directly, use `dataikuapi.DSSClient.get\_user()` instead.

`delete`()

Deletes the user

`get_settings`()

Gets the settings of the user

* Return type: `DSSUserSettings`

`get_activity`()

Gets the activity of the user

* Returns: the user’s activity

* Return type: `DSSUserActivity`

`get_definition`()

Deprecated, use get\_settings instead

Get the user’s definition (login, type, display name, permissions, …)

* Returns: the user’s definition, as a dict

`set_definition`(*definition*)

Deprecated, use get\_settings instead

Set the user’s definition. Note: this call requires an API key with admin rights

You should only `set\_definition()` using an object that you obtained through `get\_definition()`,  not create a new dict.

The fields that may be changed in a user definition are:

* email

* displayName

* groups

* userProfile

* password

* Parameters: **definition** (*dict*) – the definition for the user, as a dict

`get_client_as`()

Gets a `dataikuapi.DSSClient` that has the permissions of this user.

This allows administrators to impersonate actions on behalf of other users, in order to perform actions on their behalf

*class* `dataikuapi.dss.admin.``DSSUserSettings`(*client*, *login*, *settings*)

Settings for a DSS user. Do not create this object directly, use `DSSUser.get\_settings()` instead.

*property* `admin_properties`

The user properties (not editable by the user) for this user. Do not set this property, modify the dict in place

* Return type: dict

*property* `enabled`

Whether this user is enabled

* Return type: boolean

*property* `creation_date`

Get the creation date of the user as a `datetime.datetime`

* Returns: the creation date

* Return type: `datetime.datetime` or None

`save`()

Saves the settings

`add_secret`(*name*, *value*)

Adds a user secret. If there was already a secret with the same name, it is replaced

`get_raw`()

* Returns: the raw settings of the user, as a dict. Modifications made to the returned object are reflected when saving

* Return type: dict

`remove_connection_credential`(*connection*)

Removes per-user-credentials for a connection

`remove_plugin_credential`(*plugin\_id*, *param\_set\_id*, *preset\_id*, *param\_name*)

Removes per-user-credentials for a plugin preset

`remove_secret`(*name*)

Removes a user secret based on its name

`set_basic_connection_credential`(*connection*, *user*, *password*)

Sets per-user-credentials for a connection that takes a user/password pair

`set_basic_plugin_credential`(*plugin\_id*, *param\_set\_id*, *preset\_id*, *param\_name*, *user*, *password*)

Sets per-user-credentials for a plugin preset that takes a user/password pair

`set_oauth2_plugin_credential`(*plugin\_id*, *param\_set\_id*, *preset\_id*, *param\_name*, *refresh\_token*)

Sets per-user-credentials for a plugin preset that takes a OAuth refresh token

*property* `user_properties`

The user properties (editable by the user) for this user. Do not set this property, modify the dict in place

:rtype dict

*class* `dataikuapi.dss.admin.``DSSOwnUser`(*client*)

A handle to interact with your own user Do not create this object directly, use `dataikuapi.DSSClient.get\_own\_user()` instead.

`get_settings`()

Get your own settings

* Return type: `DSSOwnUserSettings`

*class* `dataikuapi.dss.admin.``DSSOwnUserSettings`(*client*, *settings*)

Settings for the current DSS user. Do not create this object directly, use `dataikuapi.DSSClient.get\_own\_user()` instead.

`save`()

Saves the settings

`add_secret`(*name*, *value*)

Adds a user secret. If there was already a secret with the same name, it is replaced

`get_raw`()

* Returns: the raw settings of the user, as a dict. Modifications made to the returned object are reflected when saving

* Return type: dict

`remove_connection_credential`(*connection*)

Removes per-user-credentials for a connection

`remove_plugin_credential`(*plugin\_id*, *param\_set\_id*, *preset\_id*, *param\_name*)

Removes per-user-credentials for a plugin preset

`remove_secret`(*name*)

Removes a user secret based on its name

`set_basic_connection_credential`(*connection*, *user*, *password*)

Sets per-user-credentials for a connection that takes a user/password pair

`set_basic_plugin_credential`(*plugin\_id*, *param\_set\_id*, *preset\_id*, *param\_name*, *user*, *password*)

Sets per-user-credentials for a plugin preset that takes a user/password pair

`set_oauth2_plugin_credential`(*plugin\_id*, *param\_set\_id*, *preset\_id*, *param\_name*, *refresh\_token*)

Sets per-user-credentials for a plugin preset that takes a OAuth refresh token

*property* `user_properties`

The user properties (editable by the user) for this user. Do not set this property, modify the dict in place

:rtype dict

*class* `dataikuapi.dss.admin.``DSSUserActivity`(*client*, *login*, *activity*)

Activity for a DSS user. Do not create this object directly, use `DSSUser.get\_activity()` or `DSSClient.list\_users\_activity()` instead.

`get_raw`()

Get the raw activity of the user as a dict.

* Returns: the raw activity

* Return type: dict

*property* `last_successful_login`

Get the last successful login of the user as a `datetime.datetime`

Returns None if there was no successful login for this user.

* Returns: the last successful login

* Return type: `datetime.datetime` or None

*property* `last_failed_login`

Get the last failed login of the user as a `datetime.datetime`

Returns None if there were no failed login for this user.

* Returns: the last failed login

* Return type: `datetime.datetime` or None

*property* `last_session_activity`

Get the last session activity of the user as a `datetime.datetime`, i.e. the last time the user opened a new DSS tab or refreshed his session.

Returns None if there is no session activity yet.

* Returns: the last session activity

* Return type: `datetime.datetime` or None

*class* `dataikuapi.dss.admin.``DSSGroup`(*client*, *name*)

A group on the DSS instance. Do not create this object directly, use `dataikuapi.DSSClient.get\_group()` instead.

`delete`()

Deletes the group

`get_definition`()

Get the group’s definition (name, description, admin abilities, type, ldap name mapping)

* Returns: the group’s definition, as a dict

`set_definition`(*definition*)

Set the group’s definition.

You should only `set\_definition()` using an object that you obtained through `get\_definition()`,  not create a new dict.

* Args:: definition: the definition for the group, as a dict

*class* `dataikuapi.dss.admin.``DSSAuthorizationMatrix`(*authorization\_matrix*)

The authorization matrix of all groups and enabled users of the DSS instance. Do not create this object directly, use `dataikuapi.DSSClient.get\_authorization\_matrix()` instead.

*property* `raw`

Get the raw authorization matrix as a dict

* Returns: the authorization matrix

* Return type: dict
