# Meanings[¶](https://doc.dataiku.com/dss/latest/python-api/rest-api-client/meanings.html#meanings "Permalink to this headline")

The API offers methods to retrieve the list of meanings and their definition, to create a new meaning or update an existing one.

## Listing meanings[¶](https://doc.dataiku.com/dss/latest/python-api/rest-api-client/meanings.html#listing-meanings "Permalink to this headline")

The list of all user-defined meanings can be fetched with the `list\_meanings()` method of the `DSSClient`.

§ client.list\_meanings()

## Creating a meaning[¶](https://doc.dataiku.com/dss/latest/python-api/rest-api-client/meanings.html#creating-a-meaning "Permalink to this headline")

The `create\_meaning()` method of the `DSSClient` can be used to create new meanings.

§ # Creating a declarative meaning

§ client.create\_meaning("meaning\_1", "Test meaning", "DECLARATIVE",

§ description="Test meaning description"

§ )

§ # Creating a value list meaning

§ client.create\_meaning("meaning\_2", "Test meaning", "VALUES\_LIST",

§ description="Test meaning",

§ values=["mercury","venus","earth","mars","jupiter","saturn","uranus","neptune"],

§ normalizationMode="LOWERCASE"

§ )

§ # Creating a value mapping meaning

§ client.create\_meaning("meaning\_3", "Test meaning", "VALUES\_MAPPING",

§ mappings=[

§ {"from": "0", "to": "no"   },

§ {"from": "1", "to": "yes"  },

§ {"from": "2", "to": "maybe"}

§ ]

§ )

§ # Creating a pattern meaning

§ client.create\_meaning("meaning\_4", "Test meaning", "PATTERN", pattern="[A-Z]+")

## Editing a meaning[¶](https://doc.dataiku.com/dss/latest/python-api/rest-api-client/meanings.html#editing-a-meaning "Permalink to this headline")

Existing meanings can be fetched by calling the `get\_meaning()` method of the `DSSClient` with the meaning ID. It returns a meaning handle that can be used to get or set the meaning’s definition with `get\_definition()` and `set\_definition()`, as follows:

§ meaning = client.get\_meaning("meaning\_1")

§ definition = meaning.get\_definition()

§ definition['label'] = "New label"

§ definition['description'] = "New description"

§ meaning.set\_definition(definition)

## Assigning a meaning to a column[¶](https://doc.dataiku.com/dss/latest/python-api/rest-api-client/meanings.html#assigning-a-meaning-to-a-column "Permalink to this headline")

Meanings can be assigned to columns by editing the schema of their dataset and setting the ‘meaning’ field of the column to the ID of the desired meaning.

§ dataset = client.get\_project("TEST\_PROJECT").get\_dataset("TEST\_DATASET")

§ schema = dataset.get\_schema()

§ schema['columns'][2]['meaning'] = "meaning\_1"

§ dataset.set\_schema(schema)

## Reference documentation[¶](https://doc.dataiku.com/dss/latest/python-api/rest-api-client/meanings.html#module-dataikuapi.dss.meaning "Permalink to this headline")

*class* `dataikuapi.dss.meaning.``DSSMeaning`(*client*, *id*)

A user-defined meaning on the DSS instance

`get_definition`()

Get the meaning’s definition.

Note: this call requires an API key with admin rights

* Returns: the meaning definition, as a dict. The precise structure of the dict depends on the meaning type and is not documented.

`set_definition`(*definition*)

Set the meaning’s definition.

Note: this call requires an API key with admin rights

* Parameters: **definition** (*dict*) – the definition for the meaning, as a dict. You should only `set\_definition` on a modified version of a dict you retrieved via `get\_definition()`
