# Static insights[¶](https://doc.dataiku.com/dss/latest/python-api/static_insights.html#static-insights "Permalink to this headline")

In DSS code recipes and notebooks, you can create static insights: data files that are created by code and that can be rendered on the dashboard.

This capability can notably be used to embed in one click charts created using:

* Plot.ly

* Matplotlib

* Bokeh

* Ggplot

You can also use it for embedding in the dashboard any kind of content (image, HTML, …)

* 
`dataiku.insights.``save_data`(*id*, *payload*, *content\_type*, *label=None*, *project\_key=None*, *encoding=None*)[¶](https://doc.dataiku.com/dss/latest/python-api/static_insights.html#dataiku.insights.save_data "Permalink to this definition"): Saves data as a DSS static insight that can be exposed on the dashboard
Parameters
* **id** (*str*) – Unique identifier of the insight within the project. If an insight with the same identifier
already exists, it will be replaced
* **payload** – bytes-oriented data, or Base64 string
* **content\_type** – the MIME type of the data in payload (example: text/html or image/png)
* **label** (*str*) – Optional display label for the insight. If None, the id will be used as label
* **project\_key** (*str*) – Project key in which the insight must be saved. If None, the contextual (current)
project is used
* **encoding** (*str*) – If the payload was a Base64 string, this must be “base64”. Else, this must be None

* Parameters: * **id** (*str*) – Unique identifier of the insight within the project. If an insight with the same identifier
already exists, it will be replaced
* **payload** – bytes-oriented data, or Base64 string
* **content\_type** – the MIME type of the data in payload (example: text/html or image/png)
* **label** (*str*) – Optional display label for the insight. If None, the id will be used as label
* **project\_key** (*str*) – Project key in which the insight must be saved. If None, the contextual (current)
project is used
* **encoding** (*str*) – If the payload was a Base64 string, this must be “base64”. Else, this must be None

* 
`dataiku.insights.``save_figure`(*id*, *figure=None*, *label=None*, *project\_key=None*)[¶](https://doc.dataiku.com/dss/latest/python-api/static_insights.html#dataiku.insights.save_figure "Permalink to this definition"): Saves a matplotlib or seaborn figure as a DSS static insight that can be exposed on the dashboard
Parameters
* **id** (*str*) – Unique identifier of the insight within the project. If an insight with the same identifier
already exists, it will be replaced
* **figure** – a matplotlib or seaborn figure object. If None, the latest processed figure will be used
* **label** (*str*) – Optional display label for the insight. If None, the id will be used as label
* **project\_key** (*str*) – Project key in which the insight must be saved. If None, the contextual (current)
project is used

* Parameters: * **id** (*str*) – Unique identifier of the insight within the project. If an insight with the same identifier
already exists, it will be replaced
* **figure** – a matplotlib or seaborn figure object. If None, the latest processed figure will be used
* **label** (*str*) – Optional display label for the insight. If None, the id will be used as label
* **project\_key** (*str*) – Project key in which the insight must be saved. If None, the contextual (current)
project is used

* 
`dataiku.insights.``save_bokeh`(*id*, *bokeh\_obj*, *label=None*, *project\_key=None*)[¶](https://doc.dataiku.com/dss/latest/python-api/static_insights.html#dataiku.insights.save_bokeh "Permalink to this definition"): Saves a Bokeh object as a DSS static insight that can be exposed on the dashboard
A static HTML export of the provided Bokeh object is done
Parameters
* **id** (*str*) – Unique identifier of the insight within the project. If an insight with the same identifier
already exists, it will be replaced
* **bokeh\_obj** – a Bokeh object
* **label** (*str*) – Optional display label for the insight. If None, the id will be used as label
* **project\_key** (*str*) – Project key in which the insight must be saved. If None, the contextual (current)
project is used

* Parameters: * **id** (*str*) – Unique identifier of the insight within the project. If an insight with the same identifier
already exists, it will be replaced
* **bokeh\_obj** – a Bokeh object
* **label** (*str*) – Optional display label for the insight. If None, the id will be used as label
* **project\_key** (*str*) – Project key in which the insight must be saved. If None, the contextual (current)
project is used

* 
`dataiku.insights.``save_plotly`(*id*, *figure*, *label=None*, *project\_key=None*)[¶](https://doc.dataiku.com/dss/latest/python-api/static_insights.html#dataiku.insights.save_plotly "Permalink to this definition"): Saves a Plot.ly figure as a DSS static insight that can be exposed on the dashboard
A static HTML export of the provided Plot.ly object is done
Parameters
* **id** (*str*) – Unique identifier of the insight within the project. If an insight with the same identifier
already exists, it will be replaced
* **figure** – a Plot.ly figure
* **label** (*str*) – Optional display label for the insight. If None, the id will be used as label
* **project\_key** (*str*) – Project key in which the insight must be saved. If None, the contextual (current)
project is used

* Parameters: * **id** (*str*) – Unique identifier of the insight within the project. If an insight with the same identifier
already exists, it will be replaced
* **figure** – a Plot.ly figure
* **label** (*str*) – Optional display label for the insight. If None, the id will be used as label
* **project\_key** (*str*) – Project key in which the insight must be saved. If None, the contextual (current)
project is used

* 
`dataiku.insights.``save_ggplot`(*id*, *gg*, *label=None*, *width=None*, *height=None*, *dpi=None*, *project\_key=None*)[¶](https://doc.dataiku.com/dss/latest/python-api/static_insights.html#dataiku.insights.save_ggplot "Permalink to this definition"): Saves a ggplot object as a DSS static insight that can be exposed on the dashboard
Parameters
* **id** (*str*) – Unique identifier of the insight within the project. If an insight with the same identifier
already exists, it will be replaced
* **gg** – a ggplot object
* **label** (*str*) – Optional display label for the insight. If None, the id will be used as label
* **width** (*int*) – Width of the image export
* **height** (*int*) – Height of the image export
* **dpi** (*int*) – Resolution in dots per inch of the image export
* **project\_key** (*str*) – Project key in which the insight must be saved. If None, the contextual (current)
project is used

* Parameters: * **id** (*str*) – Unique identifier of the insight within the project. If an insight with the same identifier
already exists, it will be replaced
* **gg** – a ggplot object
* **label** (*str*) – Optional display label for the insight. If None, the id will be used as label
* **width** (*int*) – Width of the image export
* **height** (*int*) – Height of the image export
* **dpi** (*int*) – Resolution in dots per inch of the image export
* **project\_key** (*str*) – Project key in which the insight must be saved. If None, the contextual (current)
project is used
