# Statistics worksheets[¶](https://doc.dataiku.com/dss/latest/python-api/statistics.html#statistics-worksheets "Permalink to this headline")

## Reference documentation[¶](https://doc.dataiku.com/dss/latest/python-api/statistics.html#module-dataikuapi.dss.statistics "Permalink to this headline")

*class* `dataikuapi.dss.statistics.``DSSStatisticsWorksheet`(*client*, *project\_key*, *dataset\_name*, *worksheet\_id*)

A handle to interact with a worksheet.

`delete`()

Deletes the worksheet

`get_settings`()

Fetches the settings of this worksheet.

* Returns: an object to interact with the settings

* Return type: `DSSStatisticsWorksheetSettings`

`run_worksheet`(*wait=True*)

Computes the results of the whole worksheet.

* Returns: a `DSSStatisticsCardResult` if wait is True, or a `DSSFuture` handle otherwise

`run_card`(*card*, *wait=True*)

Runs a card in the context of the worksheet.

Note: the card does not need to belong to the worksheet.

* Parameters: **card** (`DSSStatisticsCardSettings` or dict (obtained from `DSSStatisticsCardSettings.get\_raw()`)) – a card to compute

* Returns: a `DSSStatisticsCardResult` if wait is True, or a `DSSFuture` handle otherwise

`run_computation`(*computation*, *wait=True*)

Runs a computation in the context of the worksheet.

* Parameters: **computation** (`DSSStatisticsComputationSettings` or dict (obtained from `DSSStatisticsComputationSettings.get\_raw()`)) – a card to compute

* Returns: a `DSSStatisticsComputationResult`, or a `DSSFuture` handle otherwise

*class* `dataikuapi.dss.statistics.``DSSStatisticsWorksheetSettings`(*client*, *project\_key*, *dataset\_name*, *worksheet\_id*, *worksheet\_definition*)

`add_card`(*card*)

Adds a new card to the worksheet.

* Parameters: **card** (`DSSStatisticsCardSettings` or dict (obtained from `DSSStatisticsCardSettings.get\_raw()`)) – card to be added

`list_cards`()

Lists the cards of this worksheet.

* Return type: list of `DSSStatisticsCardSettings`

`get_raw`()

Gets a reference to the raw settings of the worksheet.

* Return type: dict

`set_sampling_settings`(*selection*)

Sets the sampling settings of the worksheet

`get_raw_sampling_settings`()

Gets a reference to the raw sampling settings of the worksheet.

* Return type: dict

`save`()

Saves the settings to DSS

*class* `dataikuapi.dss.statistics.``DSSStatisticsCardSettings`(*client*, *card\_definition*)

Object to manipulate the settings of a card

`get_raw`()

Gets a reference to the raw settings of the card.

* Return type: dict

`compile`()

Gets the underlying computation used to compute the card results.

* Return type: DSSStatisticsComputationSettings

*class* `dataikuapi.dss.statistics.``DSSStatisticsCardResult`(*card\_result*)

Object storing the results of a `DSSStatisticsCardSettings`

`get_raw`()

Gets a reference to the raw results of the card

* Return type: dict

*class* `dataikuapi.dss.statistics.``DSSStatisticsComputationSettings`(*computation\_definition*)

Object to manipulate the settings of a computation

`get_raw`()

Gets the raw settings of the computation.

* Return type: dict

*class* `dataikuapi.dss.statistics.``DSSStatisticsComputationResult`(*computation\_result*)

Object storing the results of a `DSSStatisticsComputationSettings`

`get_raw`()

Gets a reference to the raw results of the computation

* Return type: dict
