# Webapps[¶](https://doc.dataiku.com/dss/latest/python-api/webapps.html#webapps "Permalink to this headline")

The webapps API can control all aspects of managing a webapp.

* Example use cases

+ List the webapps of a project and get a handle for the first one.

+ Get a webapp by id. Check if the webapp is running, and if not, start it.

+ Stop a webapp backend.

+ Get the settings of a webapp to change the it’s name.

* Reference documentation

## Example use cases[¶](https://doc.dataiku.com/dss/latest/python-api/webapps.html#example-use-cases "Permalink to this headline")

In all examples, project is a `dataikuapi.dss.project.DSSProject` handle, obtained using client.get\_project() or client.get\_default\_project()

### List the webapps of a project and get a handle for the first one.[¶](https://doc.dataiku.com/dss/latest/python-api/webapps.html#list-the-webapps-of-a-project-and-get-a-handle-for-the-first-one "Permalink to this headline")

By default, `list\_webapps()` returns a list of dict items describing the webapps of a project. From the dict item, the `dataikuAPI.dss.webapp.DSSWebApp` handle can be obtained using the `to\_webapp()` method. Documentation of the `list\_webapps()` and `get\_webapp()` methods can be found in the API projects documentation.

§ project\_webapps = project.list\_webapps()

§ my\_webapp\_dict = project\_webapps[0]

§ print("Webapp name : %s" % my\_webapp\_dict["name"])

§ print("Webapp id : %s" % my\_webapp\_dict["id"])

§ my\_webapp = project\_webapps[0].to\_webapp()

### Get a webapp by id. Check if the webapp is running, and if not, start it.[¶](https://doc.dataiku.com/dss/latest/python-api/webapps.html#get-a-webapp-by-id-check-if-the-webapp-is-running-and-if-not-start-it "Permalink to this headline")

A handle to a webapps state `dataikuAPI.dss.webapp.DSSWebAppBackendState` object can be obtained using the `get\_state()` method.

§ my\_webapp = project.get\_webapp(my\_webapp\_id)

§ if (not my\_webapp.get\_state().running):

§ my\_webapp.start\_or\_restart\_backend()

### Stop a webapp backend.[¶](https://doc.dataiku.com/dss/latest/python-api/webapps.html#stop-a-webapp-backend "Permalink to this headline")

§ my\_webapp = project.get\_webapp(my\_webapp\_id)

§ my\_webapp.stop\_backend()

### Get the settings of a webapp to change the it’s name.[¶](https://doc.dataiku.com/dss/latest/python-api/webapps.html#get-the-settings-of-a-webapp-to-change-the-it-s-name "Permalink to this headline")

A handle to a webapps settings `dataikuAPI.dss.webapp.DSSWebAppSettings` object can be obtained using the `get\_settings()` method.

§ my\_webapp = project.get\_webapp(my\_webapp\_id)

§ settings = my\_webapp.get\_settings()

§ print("Current webapp name : %s" % settings.data["name"])

§ settings.data["name"] = "new webapp name"

§ print("New webapp name : %s" % settings.data["name"])

§ settings.save()

## Reference documentation[¶](https://doc.dataiku.com/dss/latest/python-api/webapps.html#module-dataikuapi.dss.webapp "Permalink to this headline")

*class* `dataikuapi.dss.webapp.``DSSWebApp`(*client*, *project\_key*, *webapp\_id*)

A handle to manage a webapp

`get_state`()

Return the backend state of the webapp :return: the state of the webapp :rtype: `DSSWebAppBackendState`

`stop_backend`()

Stop the backend of the webapp

`start_or_restart_backend`()

Restart the backend of the webapp :returns: a handle to a DSS future to track the progress of the restart :rtype: `dataikuapi.dss.future.DSSFuture`

`get_settings`()

Returns the settings of the webapp

* Return type: `DSSWebAppSettings`

*class* `dataikuapi.dss.webapp.``DSSWebAppBackendState`(*webapp\_id*, *state*)

An object holding the state of the backend of a webapp

*property* `state`

*property* `running`

*class* `dataikuapi.dss.webapp.``DSSWebAppSettings`(*client*, *webapp*, *data*)

A handle to manage a WebApp definition

`get_raw`()

`save`()

Save the current webapp settings and update it.

*class* `dataikuapi.dss.webapp.``DSSWebAppListItem`(*client*, *data*)

An item in a list of webapps. Do not instantiate this class, use :meth:`dataikuapi.dss.project.DSSProject.list\_webapps

`to_webapp`()

Gets the `DSSWebApp` corresponding to this webapp

*property* `id`

*property* `name`
