# DSS and Python[¶](https://doc.dataiku.com/dss/latest/python/index.html#dss-and-python "Permalink to this headline")

DSS includes deep integration with Python. In many parts of DSS, you can write Python code:

* In recipes

* In Jupyter notebooks

* In standard webapp backends

* In scenarios, metrics and checks

* In plugins

* For custom models in visual ML

* In API node, for custom prediction models or custom functions endpoints

Any Python package may be used in DSS.

In addition, DSS features a complete Python API, which has its own complete documentation.

The following highlights how a few specific Python packages can be used in DSS. DSS features advanced integration with most of the packages described below.

* Installing Python packages

+ Additional prerequisites

+ Installing in a specific code environment (recommended)

+ Installing in the built-in DSS environment (not recommended)

- Python packages available through pip

- Installing without Internet access

- Installing a “python setup.py install” package

+ Installing custom Python packages

* Reusing Python code

+ Sharing Python code within a project

- Working with multiple source folders

+ Importing libraries from other projects

+ Sharing Python code globally

- Permissions

- Caution

+ Manual editing of code library folders

+ Packaging code as plugins

* Using Matplotlib

+ Installing Matplotlib

+ Displaying charts in a Jupyter notebook

+ Displaying Matplotlib charts on a dashboard

- Refreshing charts on a dashboard

+ Using matplotlib in a recipe

* Using SpaCy

+ Installing SpaCy

+ Using SpaCy models

* Using Bokeh

+ Installing Bokeh

+ Creating a Bokeh interactive web application

+ Displaying charts in a Jupyter notebook

- Using interactive controls in the Jupyter notebook

+ Displaying Bokeh charts on a dashboard

- Refreshing charts on a dashboard

+ Displaying images in Bokeh

- In a Jupyter notebook

- In a webapp

* Using Plot.ly

+ Installing plot.ly

+ Displaying charts in a Jupyter notebook

+ Displaying charts on a dashboard

- Refreshing charts on a dashboard

* Using Ggplot

* Using Jupyter Widgets

+ Setup

+ Using widgets
