# Using Jupyter Widgets[¶](https://doc.dataiku.com/dss/latest/python/ipywidgets.html#using-jupyter-widgets "Permalink to this headline")

Jupyter Widgets (a.k.a ipywidgets) are a way to build interactive GUIs in Jupyter notebooks.

For more information about widgets, see the documentation.

## Setup[¶](https://doc.dataiku.com/dss/latest/python/ipywidgets.html#setup "Permalink to this headline")

Support for widgets needs to be enabled globally in the DSS Jupyter notebook by an administrator

* Go to the DSS data directory

* Run the following commands, where

>

>

> 	+ DATADIR is the absolute path to the DSS data directory

> 	+ INSTALLDIR is the absolute path to the DSS installation directory (`dataiku-dss-X.Y.Z`)

>

> ```

> JUPYTER\_CONFIG\_DIR="$DATADIR/jupyter-run/jupyter" JUPYTER\_DATA\_DIR="$DATADIR/jupyter-run/jupyter"  PYTHONPATH="$INSTALLDIR/dku-jupyter/packages/" ./bin/python -m notebook.nbextensions install --py widgetsnbextension --user

>

> JUPYTER\_CONFIG\_DIR="$DATADIR/jupyter-run/jupyter" JUPYTER\_DATA\_DIR="$DATADIR/jupyter-run/jupyter"  PYTHONPATH="$INSTALLDIR/dku-jupyter/packages/" ./bin/python -m notebook.nbextensions enable --py widgetsnbextension

>

> ```

>

>

>

* Check installation:

>

>

> ```

> JUPYTER\_CONFIG\_DIR="$DATADIR/jupyter-run/jupyter" JUPYTER\_DATA\_DIR="$DATADIR/jupyter-run/jupyter"  PYTHONPATH="$INSTALLDIR/dku-jupyter/packages/" ./bin/python -m notebook.nbextensions list

>

> ```

>

>

>

This command should have output like:

§ jupyter-js-widgets/extension  enabled

§ - Validating: OK

* Edit `bin/env-site.sh` and add the following line

>

>

> ```

> export JUPYTER\_CONFIG\_DIR="$DIP\_HOME/jupyter-run/jupyter"

>

> ```

>

>

>

* Restart DSS

## Using widgets[¶](https://doc.dataiku.com/dss/latest/python/ipywidgets.html#using-widgets "Permalink to this headline")

Open a new notebook, and enter sample widget code:

Note

If you are using a custom code env, don’t forget to included the ipywidgets package in your code env

§ import ipywidgets

§ ipywidgets.IntSlider()

A slider should appear. You can now use ipywidgets.
