# Checks[¶](https://doc.dataiku.com/dss/latest/scenarios/checks.html#checks "Permalink to this headline")

* Checks

+ Numeric range check

+ Value in set check

+ Python check

* Checks display UI

The checks system in DSS allows you to automatically run checks on Flow items (datasets, managed folders, and saved models). The checks system is integrated with the metrics system in that checks have access to the last values of the metrics of the Flow item they check.

Checks run as part of a build and returning an ERROR status will fail the build. On partitioned datasets, the checks can be computed either on a per-partition basis or on the whole dataset.

Note

Checks are often used in conjunction with scenarios but are not strictly dependent on scenarios.

Examples of checks on a dataset include:

* The duration of the build for the dataset stays below 5 min

* The record count of a dataset is not 0 (i.e., the dataset is not empty)

* The most frequent value of a column is ‘Y’

Checks are configured in the *Status* tabs of datasets, managed folders and saved models, and changes are automatically tracked over time.

## Checks[¶](https://doc.dataiku.com/dss/latest/scenarios/checks.html#id1 "Permalink to this headline")

A check is a condition of some value(s), and the result of the execution of a check is a pair of:

* an outcome: “OK”, “ERROR” or “WARNING”. A fourth outcome “EMPTY” is used to indicate that the condition could not be evaluated because the value is missing.

* an optional message.

Each execution of the check produces one outcome. The value is recorded and associated to the name

### Numeric range check[¶](https://doc.dataiku.com/dss/latest/scenarios/checks.html#numeric-range-check "Permalink to this headline")

A numeric range check asserts that the value of a metric is within a given range and/or within a given soft range:

* value below minimum : ERROR

* value below soft minimum : WARNING

* value in range : OK

* value above soft maximum : WARNING

* value above maximum : ERROR

### Value in set check[¶](https://doc.dataiku.com/dss/latest/scenarios/checks.html#value-in-set-check "Permalink to this headline")

A value in set check asserts that the value of a metric is in a given list of admissible values.

### Python check[¶](https://doc.dataiku.com/dss/latest/scenarios/checks.html#python-check "Permalink to this headline")

You can also write a custom check in Python.

## Checks display UI[¶](https://doc.dataiku.com/dss/latest/scenarios/checks.html#checks-display-ui "Permalink to this headline")

The value of checks can be viewed in the “Status” tab of a dataset, managed folder or saved model.

Since there can be a lot of checks on an item, you must select which checks to display, by clicking on the `X/Y checks` button

There are two check views:

* A “list” view which displays the history of all selected checks.

* A “table” view which displays the latest value of each selected check.
