# Dataiku 11: Connect Your Experts With the Platform for Everyday AI[¶](https://knowledge.dataiku.com/latest/courses/crash-course/dss11/introduction.html#dataiku-11-connect-your-experts-with-the-platform-for-everyday-ai "Permalink to this headline")

This Crash Course will bring you up to speed on many of the new features and tools in Dataiku 11 that build on core strengths to connect and engage experts with the platform and empower your skilled workforce.

## Engage Your Expert Technical Community[¶](https://knowledge.dataiku.com/latest/courses/crash-course/dss11/introduction.html#engage-your-expert-technical-community "Permalink to this headline")

Dataiku 11 provides the tools for your expert technical community to work in familiar frameworks and experiment faster with advanced tools and capabilities — all on a stable, centralized, and deployment-ready platform.

The release includes:

* Code Studios: Use your preferred IDE or WebApp stack in Dataiku with ready-to-use, advanced coding environments

* Experiment tracking: Capture and compare multiple runs when building an ML model using code

* Feature Store: A central place to discover and reuse your team’s best datasets

* Managed labeling system and visual deep learning tasks: Visual interfaces for image classification, object detection, and a collaborative framework for data annotation

## Empower Your Skilled Workforce[¶](https://knowledge.dataiku.com/latest/courses/crash-course/dss11/introduction.html#empower-your-skilled-workforce "Permalink to this headline")

Empower business teams to take on data science challenges with easy data and feature discovery, powerful data preparation and prescriptive insights that deliver better business decisions.

New features in Dataiku 11 include:

* Visual time series forecasting and statistics: Built-in, visual interfaces for time series EDA and forecasting

* Seamless sharing and access workflows: Quick sharing, project access, and request workflows to facilitate discoverability and reuse

* Outcome optimization: Generate combinations of input feature values that produce the optimal predicted outcome.

* Visual logic: Build complex rules and manage conditional logic with an enhanced interface, plus a new formula function and preparation processors

## Expand Executive Confidence and Control[¶](https://knowledge.dataiku.com/latest/courses/crash-course/dss11/introduction.html#expand-executive-confidence-and-control "Permalink to this headline")

New features in Dataiku 11 allow you to create a streamlined, centralized control center for AI that empowers IT teams to deliver operational excellence and governance best practices.

These features include:

* Flow Document Generator: Automatically generate documentation and a detailed report about the objects in your Flow

* Model stress tests: Measure how resilient your models are to potential real-world data quality issues prior to deploying

* Project bundle governance and registry: See a timeline of actions and govern project bundles with workflows, signoff, and a bundle registry

## Other Noteworthy Features[¶](https://knowledge.dataiku.com/latest/courses/crash-course/dss11/introduction.html#other-noteworthy-features "Permalink to this headline")

Dataiku 11 also includes a host of other new features that improve charting and mapping tools, custom machine learning metrics, managed custers experience, and more.

* Consumable AI enhancements: Multi-dimensional pivot tables, improved dashboard filtering, display labels, axis formatting, and workspace discussions

* Geospatial enrichment: Geomap enhancements, isochrones and geo-routing calculation

* GLMs and custom ML metrics: Train, score, and deploy Generalized Linear Models (GLMs) from the Visual ML interface, and code your own model evaluation metrics

* Managed clusters experience: Improved UI and navigation, cluster monitoring, shortcuts to cluster maintenance actions, cloud stack accelerator for GCP
