# How to Edit Dataiku Recipes in RStudio[¶](https://knowledge.dataiku.com/latest/courses/advanced-code/work-environment/rstudio.html#how-to-edit-dataiku-recipes-in-rstudio "Permalink to this headline")

## Goal[¶](https://knowledge.dataiku.com/latest/courses/advanced-code/work-environment/rstudio.html#goal "Permalink to this headline")

Though Jupyter notebooks are integrated into the Dataiku interface, many R developers use RStudio. From within RStudio, you can:

* Install the `dataiku` package

* Connect to an existing Dataiku instance

* Pull code from an R code recipe into RStudio

* Edit the code in RStudio, and then

* Save the code back to the R recipe

Note

This method can edit *existing* recipes and plugin files on the Dataiku instance, but cannot create new recipes or files.

## Prerequisites[¶](https://knowledge.dataiku.com/latest/courses/advanced-code/work-environment/rstudio.html#prerequisites "Permalink to this headline")

* You should work through the R in Dataiku tutorial, or otherwise have a project with an available R recipe.

## Technical Requirements[¶](https://knowledge.dataiku.com/latest/courses/advanced-code/work-environment/rstudio.html#technical-requirements "Permalink to this headline")

* Access to a Dataiku instance with the R integration installed

* Access to RStudio

* A personal API key to the Dataiku instance

## Install the dataiku R Package[¶](https://knowledge.dataiku.com/latest/courses/advanced-code/work-environment/rstudio.html#install-the-dataiku-r-package "Permalink to this headline")

Within RStudio, run the following code to install the `dataiku` package. Replace `URL\_Dataiku\_instance` with the URL to a Dataiku instance; for example, if the instance is using a secure protocol on localhost and listening on port 11500, then replace `URL\_Dataiku\_instance` with `https://localhost:11500`.

§ install.packages("<URL\_Dataiku\_instance>/public/packages/dataiku\_current.tar.gz", repos=NULL)

Warning

The URL will begin with either http or https, depending on how the instance was set up and whether a secure protocol was used

To install the `dataiku` package, you may need to install some dependencies. Follow RStudio’s instructions for managing R packages.

The `dataiku` package provides add-ins for connecting to a Dataiku instance and managing R recipes on the instance.

## Connect to a Dataiku Instance[¶](https://knowledge.dataiku.com/latest/courses/advanced-code/work-environment/rstudio.html#connect-to-a-dataiku-instance "Permalink to this headline")

* From the Add-ins menu, choose **Dataiku: Setup DSS instance**. This opens a dialog where you manage connections to Dataiku instances.

* Click **+Connect to Another DSS Instance** and fill out the following information:

+ **Name.** Give the connection a descriptive name.

+ **URL.** Provide the URL to your Dataiku instance; e.g. for the instance above–`https://localhost:11500`.

+ **API Key** This is the *secret* of your Personal API key.

* Select this as your active connection.

* Click **Save**.

## Edit a Dataiku Recipe[¶](https://knowledge.dataiku.com/latest/courses/advanced-code/work-environment/rstudio.html#edit-a-dataiku-recipe "Permalink to this headline")

* Open a new R Script.

* From the Add-ins menu, choose **Dataiku: download R recipe code**.

* Choose the project key of a project with an R recipe; for example, **DKU\_TUTORIAL\_R** if you completed the R and Dataiku DSS course.

* Choose the recipe you want to edit from list; for example, **compute\_orders\_by\_customer**

* Click **Download**.

The code of the Dataiku R recipe is downloaded into the R Script in RStudio. You can run the code like any other R Script in RStudio. With the `dataiku` package installed, the `dkuReadDataset()` function causes RStudio to use the Dataiku API to pull the Dataiku dataset from the server and into a local R dataframe. Other `dataiku` package functions likewise use the Dataiku API.

The exception is that you cannot write from RStudio to a Dataiku dataset. You need to save any changes you’ve made to the code back to the Dataiku recipe, and then run the recipe within Dataiku DSS.

Note

You cannot create a *new* Dataiku R recipe through RStudio using these add-ins; the R recipe must already exist.

## Save Changes to a Recipe[¶](https://knowledge.dataiku.com/latest/courses/advanced-code/work-environment/rstudio.html#save-changes-to-a-recipe "Permalink to this headline")

Changes made in RStudio are made to the recipe in Dataiku when you:

* Choose **Dataiku: save R recipe code** from the Add-ins menu.

* Click **Send to DSS**.

This overwrites any edits made in the meantime on the Dataiku instance.
