# How to Edit Dataiku Projects and Plugins in Visual Studio Code[¶](https://knowledge.dataiku.com/latest/courses/advanced-code/work-environment/vscode.html#how-to-edit-dataiku-projects-and-plugins-in-visual-studio-code "Permalink to this headline")

## Goal[¶](https://knowledge.dataiku.com/latest/courses/advanced-code/work-environment/vscode.html#goal "Permalink to this headline")

Though Jupyter notebooks are integrated into the Dataiku interface, some developers favor Visual Studio Code (VS Code) as an IDE. From within VS Code, you can:

* Install the *Dataiku DSS* extension

* Configure VS Code to connect to an existing Dataiku instance

* Pull code from an existing code recipe, plugin or library into VS Code

* Edit the code in VS Code

* Locally run and debug code, and then

* Save the code back to the code recipe, plugin, or library

Note

This integration allows you to edit existing recipes and plugins on your Dataiku instance but does not allow you to create new recipes or plugins. You can, however, create new files and folders within existing plugins and libraries.

## Prerequisites[¶](https://knowledge.dataiku.com/latest/courses/advanced-code/work-environment/vscode.html#prerequisites "Permalink to this headline")

* Familiarity with code recipes or plugins in Dataiku.

## Technical Requirements[¶](https://knowledge.dataiku.com/latest/courses/advanced-code/work-environment/vscode.html#technical-requirements "Permalink to this headline")

* Access to a Dataiku instance

* VS Code

* A personal API key to the Dataiku instance

## Install the Dataiku DSS Extension[¶](https://knowledge.dataiku.com/latest/courses/advanced-code/work-environment/vscode.html#install-the-dataiku-dss-extension "Permalink to this headline")

* In VS Code, open the **Extensions** panel.

* Search for `dataiku` in the marketplace and select **Dataiku DSS**.

The Dataiku DSS extension provides the ability to connect to a Dataiku instance and edit recipes and plugins on the instance.

## Connect to a Dataiku Instance[¶](https://knowledge.dataiku.com/latest/courses/advanced-code/work-environment/vscode.html#connect-to-a-dataiku-instance "Permalink to this headline")

Define your connection in the `~/.dataiku/config.json` file. The file should have form:

§ {

§ "dss\_instances": {

§ "designInstance": {

§ "url": "https://www.mydesigninstance.com:11500",

§ "api\_key": "your-design-API-key-secret"

§ },

§ "productionInstance": {

§ "url": "https://www.myproductioninstance.com:12500",

§ "api\_key": "your-production-API-key-secret"

§ }

§ },

§ "default\_instance": "designInstance"

§ }

This configuration file defines two instances, *designInstance* and *productionInstance*, with the following settings:

* *url.* The URL of the Dataiku instance, without / at the end

* *api\_key.* The secret for your personal API key

*designInstance* is designated as the default instance to use; this is the instance VS Code will connect to. If you change the default instance, you’ll need to restart VS Code to pick up the changes.

Note

The `~/.dataiku/config.json` file is used by all of Dataiku’s IDE integrations, so once you’ve set it up for one IDE, it’s easy to reuse for another.

## Edit a Dataiku Project or Plugin[¶](https://knowledge.dataiku.com/latest/courses/advanced-code/work-environment/vscode.html#edit-a-dataiku-project-or-plugin "Permalink to this headline")

In VS Code, open the Dataiku DSS panel. You’ll see a list of **Projects** and **Plugins**.

Under Projects, you can see the lists of **Recipes**, **Webapps**, **Wikis**, and **Libraries** within each project. Navigate to, and then open, the file you want to edit.

Under Plugins, you can see the entire folder structure of each plugin.

Changes made in VS Code are synchronized to Dataiku when you save the file.
