# Concept: External IDE Integrations[¶](https://knowledge.dataiku.com/latest/courses/advanced-code/code-in-dss/ide-integrations.html#concept-external-ide-integrations "Permalink to this headline")

In this lesson, you will learn how to edit Dataiku code objects using the integrations with common IDEs, or integrated development environments.

While the Dataiku APIs enable you to code from any IDE, there are also specific integrations with some of the most popular IDEs that allow you to pull, edit, and push back code from existing recipes, plugins, or webapps.

Though Jupyter notebooks are integrated into the Dataiku interface, some developers favor an IDE, such as Visual Studio Code (VS Code), PyCharm, Sublime, RStudio, or IntelliJ.

While these tools are external to the Dataiku interface, you can still use them to connect to a Dataiku instance and edit code recipes, plugins, and in the case of VS Code, webapps.

## VS Code Example[¶](https://knowledge.dataiku.com/latest/courses/advanced-code/code-in-dss/ide-integrations.html#vs-code-example "Permalink to this headline")

Let’s see how this works in practice, using the integration with VS Code as an example.

In order to establish a connection, Dataiku needs to know it can trust your IDE. Within your Dataiku profile, you can create a personal API key that this instance of Dataiku will recognize and trust.

In your external IDE, you can then install the Dataiku extension and configure the IDE with your personal API key to connect to your instance of Dataiku.

Once the connection is established between the IDE and Dataiku, you can pull code from an existing code recipe, webapp, or plugin into your local IDE.

Within the IDE, you can edit, locally run, and debug code, and then save your code back to the Dataiku instance.

See the video for a demonstration.

## Alternatives[¶](https://knowledge.dataiku.com/latest/courses/advanced-code/code-in-dss/ide-integrations.html#alternatives "Permalink to this headline")

Note that, with these integrations, you cannot create entirely new recipes, webapps, or plugins—you must edit existing ones.

Alternatively, you can always use the Dataiku APIs in a notebook or IDE to interact with all kinds of Dataiku objects programmatically.

The integrations with IDEs simply allow you to do this for certain objects without additional programming.

Note

You will learn more about Dataiku APIs in another course.

## What’s Next?[¶](https://knowledge.dataiku.com/latest/courses/advanced-code/code-in-dss/ide-integrations.html#what-s-next "Permalink to this headline")

This video introduced the concept of external IDE integrations in Dataiku, using VSCode as an example.

You can read more about the particulars of individual IDEs in the work environment section of the Knowledge Base.
