# Concept: What Are Development Plugins?[¶](https://knowledge.dataiku.com/latest/courses/advanced-code/plugin-dev/what-are-dev-plugins-concept-summary.html#concept-what-are-development-plugins "Permalink to this headline")

Tip

This content is also included in a free Dataiku Academy course on Plugin Development, which is part of the Developer learning path. Register for the course there if you’d like to track and validate your progress alongside concept videos, summaries, hands-on tutorials, and quizzes.

In this lesson, we’ll introduce development plugins in Dataiku DSS, the required permissions for creating them, and how to start developing them.

Plugins are a way for developers to code functionalities and package them into reusable components. These plugins can then be shared with other team members through various means, such as, by downloading zip files, or by pushing the plugin to a remote git repository.

Tip

The code for most Dataiku plugins is available in public Github repositories.

Once a plugin has been shared, non-coding team members can access and install it to utilize its functionalities via a visual interface.

## Trade-Offs With Using Plugins[¶](https://knowledge.dataiku.com/latest/courses/advanced-code/plugin-dev/what-are-dev-plugins-concept-summary.html#trade-offs-with-using-plugins "Permalink to this headline")

While plugins allow you to customize and extend the functionalities of Dataiku DSS, by using them, you generally lose the support coverage available for Dataiku’s native features.

There are some exceptions to this rule, such as the Time Series Preparation plugin, which has full support, and the Forecast plugin, which has Tier 2 support. In cases where there are exceptions, the support tier will be stated explicitly.

## Plugin Make-Up[¶](https://knowledge.dataiku.com/latest/courses/advanced-code/plugin-dev/what-are-dev-plugins-concept-summary.html#plugin-make-up "Permalink to this headline")

A plugin can include components such as datasets, notebook templates, scenario triggers, prediction algorithms, and more. Each component of a plugin is made up of:

* a point and click interface that is defined by a JSON descriptor, and

* some custom code that’s typically written in R or Python.

For example, the *Fraud monitoring* plugin consists of two components, a custom recipe (*scatterplot-3d*) and a processor (*hide-colors*). Each of these components is made up of a JSON descriptor and a custom Python code.

## Adding Existing Plugins[¶](https://knowledge.dataiku.com/latest/courses/advanced-code/plugin-dev/what-are-dev-plugins-concept-summary.html#adding-existing-plugins "Permalink to this headline")

A user with administrative privileges can add plugins by:

* installing an existing plugin from the plugin store,

* uploading a plugin as a zip export from another DSS instance, or

* fetching a plugin from a git repository.

## Creating Development Plugins[¶](https://knowledge.dataiku.com/latest/courses/advanced-code/plugin-dev/what-are-dev-plugins-concept-summary.html#creating-development-plugins "Permalink to this headline")

A user belonging to a group with the “Develop Plugins” permission can create a **development plugin** by:

* writing a custom plugin from scratch,

* converting Dataiku DSS components such as an existing code recipe or webapp to a plugin, or

* converting a plugin that has been installed from the Plugin Store into a development plugin so that its code can be customized further.

The **Development** tab of the plugin store contains a list of the development plugins on an instance of Dataiku DSS.

## What’s Next?[¶](https://knowledge.dataiku.com/latest/courses/advanced-code/plugin-dev/what-are-dev-plugins-concept-summary.html#what-s-next "Permalink to this headline")

Learn more about plugins by exploring the different ways of developing plugins.
